/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class Semaphore
implements Sync {
    protected long permits_;

    public Semaphore(long initialPermits) {
        this.permits_ = initialPermits;
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                try {
                    while (this.permits_ <= (long)0) {
                        this.wait();
                    }
                    --this.permits_;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                if (this.permits_ > (long)0) {
                    --this.permits_;
                    return true;
                }
                if (msecs <= (long)0) {
                    return false;
                }
                try {
                    long startTime = System.currentTimeMillis();
                    long waitTime = msecs;
                    do {
                        this.wait(waitTime);
                        if (this.permits_ <= (long)0) continue;
                        --this.permits_;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > (long)0);
                    return false;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                throw throwable;
            }
        }
    }

    public synchronized void release() {
        ++this.permits_;
        this.notify();
    }

    public synchronized void release(long n) {
        if (n < (long)0) {
            throw new IllegalArgumentException("Negative argument");
        }
        this.permits_ += n;
        for (long i = 0L; i < n; ++i) {
            this.notify();
        }
    }

    public synchronized long permits() {
        return this.permits_;
    }
}

