/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedVariable;

public class SynchronizedByte
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected byte value_;

    public SynchronizedByte(byte initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedByte(byte initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    public final byte get() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_;
                Object var4_3 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public byte set(byte newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte old = this.value_;
                this.value_ = newValue;
                byte by = old;
                Object var6_5 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
    }

    public boolean commit(byte assumedValue, byte newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                boolean success;
                boolean bl = success = assumedValue == this.value_;
                if (success) {
                    this.value_ = newValue;
                }
                boolean bl2 = success;
                Object var7_6 = null;
                return bl2;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte swap(SynchronizedByte other) {
        if (other == this) {
            return this.get();
        }
        SynchronizedByte fst = this;
        SynchronizedByte snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            try {
                Object object2 = snd.lock_;
                synchronized (object2) {
                    try {
                        fst.set(snd.set(fst.get()));
                        return this.get();
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                throw throwable;
            }
        }
    }

    public byte increment() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_ = (byte)(this.value_ + 1);
                Object var4_3 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public byte decrement() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_ = (byte)(this.value_ - 1);
                Object var4_3 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public byte add(byte amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_ = (byte)(this.value_ + amount);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte subtract(byte amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_ = (byte)(this.value_ - amount);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte multiply(byte factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_ = (byte)(this.value_ * factor);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte divide(byte factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_ = (byte)(this.value_ / factor);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte negate() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_ = (byte)(-this.value_);
                Object var4_3 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public byte complement() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_ = (byte)(~this.value_);
                Object var4_3 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public byte and(byte b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_ = (byte)(this.value_ & b);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte or(byte b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_ = (byte)(this.value_ | b);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte xor(byte b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                byte by = this.value_ = (byte)(this.value_ ^ b);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int compareTo(byte other) {
        byte val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedByte other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedByte)other);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedByte) {
            return this.get() == ((SynchronizedByte)other).get();
        }
        return false;
    }

    public int hashCode() {
        return this.get();
    }

    public String toString() {
        return Byte.toString(this.get());
    }
}

