/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedVariable;

public class SynchronizedDouble
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected double value_;

    public SynchronizedDouble(double initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedDouble(double initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    public final double get() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                double d = this.value_;
                Object var5_3 = null;
                return d;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                throw throwable;
            }
        }
    }

    public double set(double newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                double old = this.value_;
                this.value_ = newValue;
                double d = old;
                Object var9_5 = null;
                return d;
            }
            catch (Throwable throwable) {
                Object var9_6 = null;
                throw throwable;
            }
        }
    }

    public boolean commit(double assumedValue, double newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                boolean success;
                boolean bl = success = assumedValue == this.value_;
                if (success) {
                    this.value_ = newValue;
                }
                boolean bl2 = success;
                Object var9_6 = null;
                return bl2;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double swap(SynchronizedDouble other) {
        if (other == this) {
            return this.get();
        }
        SynchronizedDouble fst = this;
        SynchronizedDouble snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            try {
                Object object2 = snd.lock_;
                synchronized (object2) {
                    try {
                        fst.set(snd.set(fst.get()));
                        return this.get();
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                throw throwable;
            }
        }
    }

    public double add(double amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                double d = this.value_ += amount;
                Object var7_4 = null;
                return d;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public double subtract(double amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                double d = this.value_ -= amount;
                Object var7_4 = null;
                return d;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public double multiply(double factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                double d = this.value_ *= factor;
                Object var7_4 = null;
                return d;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public double divide(double factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                double d = this.value_ /= factor;
                Object var7_4 = null;
                return d;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public int compareTo(double other) {
        double val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedDouble other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedDouble)other);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedDouble) {
            return this.get() == ((SynchronizedDouble)other).get();
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.get());
        return (int)(bits ^ bits >> 32);
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

