/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedByte;

public class WaitableByte
extends SynchronizedByte {
    public WaitableByte(byte initialValue) {
        super(initialValue);
    }

    public WaitableByte(byte initialValue, Object lock) {
        super(initialValue, lock);
    }

    public byte set(byte newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                byte by = super.set(newValue);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public boolean commit(byte assumedValue, byte newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                boolean success = super.commit(assumedValue, newValue);
                if (success) {
                    this.lock_.notifyAll();
                }
                boolean bl = success;
                Object var7_6 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    public byte increment() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                byte by = super.increment();
                Object var4_3 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public byte decrement() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                byte by = super.decrement();
                Object var4_3 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public byte add(byte amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                byte by = super.add(amount);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte subtract(byte amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                byte by = super.subtract(amount);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte multiply(byte factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                byte by = super.multiply(factor);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte divide(byte factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                byte by = super.divide(factor);
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte complement() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ = ~this.value_;
                this.lock_.notifyAll();
                byte by = this.value_;
                Object var4_3 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public byte and(byte b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ = (byte)(this.value_ & b);
                this.lock_.notifyAll();
                byte by = this.value_;
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte or(byte b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ = (byte)(this.value_ | b);
                this.lock_.notifyAll();
                byte by = this.value_;
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public byte xor(byte b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ = (byte)(this.value_ ^ b);
                this.lock_.notifyAll();
                byte by = this.value_;
                Object var5_4 = null;
                return by;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenEqual(byte c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ != c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenNotEqual(byte c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ == c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenLessEqual(byte c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ > c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenLess(byte c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ >= c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenGreaterEqual(byte c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ < c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenGreater(byte c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ <= c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }
}

