/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.cache;

import com.posdata.glue.security.cache.PosAttributeContent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class PosAbstractContent
implements Serializable {
    public static final String COMMON_START_ACTIVE_DATE_CONTENT_FIELD = "StartActiveDate";
    public static final String COMMON_END_ACTIVE_DATE_CONTENT_FIELD = "EndActiveDate";
    protected String id = null;
    protected Map attributesMap = new HashMap(10);

    public PosAbstractContent() {
    }

    public PosAbstractContent(String id) {
        this.id = id;
    }

    public PosAttributeContent getAttribute(String key) {
        return (PosAttributeContent)this.attributesMap.get(key);
    }

    public String getAttributeValue(String key) {
        if ((PosAttributeContent)this.attributesMap.get(key) == null) {
            return null;
        }
        return ((PosAttributeContent)this.attributesMap.get(key)).getValue();
    }

    public void setAttribute(String key, PosAttributeContent posAttributeContent) {
        this.attributesMap.put(key, posAttributeContent);
    }

    public PosAttributeContent[] getAttributes() {
        return (PosAttributeContent[])this.attributesMap.values().toArray();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isValidObject() {
        try {
            Date currentDate = new Date();
            String startDateString = this.getAttributeValue(COMMON_START_ACTIVE_DATE_CONTENT_FIELD);
            String endDateString = this.getAttributeValue(COMMON_END_ACTIVE_DATE_CONTENT_FIELD);
            if (startDateString == null || endDateString == null) {
                return true;
            }
            Date startDate = new SimpleDateFormat("yyyyMMddHHmmss").parse(startDateString);
            Date endDate = new SimpleDateFormat("yyyyMMddHHmmss").parse(endDateString);
            return currentDate.after(startDate) && currentDate.before(endDate);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

