/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.scheduling;

import com.posdata.glue.security.common.util.PosSecureCacheUtil;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.io.File;

public class PosSecureDataScheduler {
    private PosLog logger = PosLogFactory.getLogger(this.getClass());
    protected PosSecureCacheUtil posSecureCacheUtil;
    protected long lastModifyTimeForUser;
    protected long lastModifyTimeForResp;
    protected long lastModifyTimeForFunction;
    protected long lastModifyTimeForUserRespMapping;

    public PosSecureDataScheduler(PosSecureCacheUtil posSecureCacheUtil) {
        this.posSecureCacheUtil = posSecureCacheUtil;
        this.initializingSecurityDataFileTime();
    }

    public void initializingSecurityDataFileTime() {
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)"Initializing Security Data File Timestamp .....");
        }
        this.setLastModifyTimeForUser(this.getCurrentFileTimeStamp(this.posSecureCacheUtil.getFilePathForUser()));
        this.setLastModifyTimeForFunction(this.getCurrentFileTimeStamp(this.posSecureCacheUtil.getFilePathForFunction()));
        this.setLastModifyTimeForResp(this.getCurrentFileTimeStamp(this.posSecureCacheUtil.getFilePathForResp()));
        this.setLastModifyTimeForUserRespMapping(this.getCurrentFileTimeStamp(this.posSecureCacheUtil.getFilePathForUserResp()));
    }

    public void loadSecurityData() {
        try {
            long currentFileModifiedTime = -1L;
            boolean isUserLoading = false;
            boolean isRespLoading = false;
            boolean isFunctionLoading = false;
            boolean isUserRespMappingLoading = false;
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"Security Data File Update Checking .....");
            }
            if ((currentFileModifiedTime = this.compareUserFileModified()) >= 0L) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"User File loading.....");
                }
                isUserLoading = this.posSecureCacheUtil.putUserInfoContent();
                this.setLastModifyTimeForUser(currentFileModifiedTime);
            }
            if ((currentFileModifiedTime = this.compareFunctionFileModified()) >= 0L) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"function File loading.....");
                }
                isFunctionLoading = this.posSecureCacheUtil.putFunctionInfoContent();
                this.setLastModifyTimeForFunction(currentFileModifiedTime);
            }
            if ((currentFileModifiedTime = this.compareRespFileModified()) >= 0L) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"Responsibility File loading.....");
                }
                if (!isRespLoading) {
                    this.posSecureCacheUtil.putRespInfoContent();
                }
                this.setLastModifyTimeForResp(currentFileModifiedTime);
            }
            if ((currentFileModifiedTime = this.compareUserRespFileModified()) >= 0L) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"User-Responsibility Mapping File loading.....");
                }
                if (!isUserRespMappingLoading) {
                    this.posSecureCacheUtil.putUserRespInfoContent();
                }
                this.setLastModifyTimeForResp(currentFileModifiedTime);
            }
        }
        catch (Exception ex) {
            this.logger.logFatal((Object)("SecurityData Loading Error : " + ex.getMessage()));
            this.logger.logFatal((Object)ex);
        }
    }

    private long compareUserFileModified() {
        long currentFileTime = this.getCurrentFileTimeStamp(this.posSecureCacheUtil.getFilePathForUser());
        if (this.getLastModifyTimeForUser() != currentFileTime) {
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"User File Modified .....");
            }
            return currentFileTime;
        }
        return -1L;
    }

    private long compareUserRespFileModified() {
        long currentFileTime = this.getCurrentFileTimeStamp(this.posSecureCacheUtil.getFilePathForUserResp());
        if (this.getLastModifyTimeForUserRespMapping() != currentFileTime) {
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"User Resp Mapping File Modified .....");
            }
            return currentFileTime;
        }
        return -1L;
    }

    private long compareRespFileModified() {
        long currentFileTime = this.getCurrentFileTimeStamp(this.posSecureCacheUtil.getFilePathForResp());
        if (this.getLastModifyTimeForResp() != currentFileTime) {
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"Responsibility File Modified .....");
            }
            return currentFileTime;
        }
        return -1L;
    }

    private long compareFunctionFileModified() {
        long currentFileTime = this.getCurrentFileTimeStamp(this.posSecureCacheUtil.getFilePathForFunction());
        if (this.getLastModifyTimeForFunction() != currentFileTime) {
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"Function File Modified .....");
            }
            return currentFileTime;
        }
        return -1L;
    }

    private long getCurrentFileTimeStamp(String filePath) {
        try {
            File file = new File(filePath);
            return file.lastModified();
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public long getLastModifyTimeForUser() {
        return this.lastModifyTimeForUser;
    }

    public void setLastModifyTimeForUser(long lastModifyTimeForUser) {
        this.lastModifyTimeForUser = lastModifyTimeForUser;
    }

    public long getLastModifyTimeForResp() {
        return this.lastModifyTimeForResp;
    }

    public void setLastModifyTimeForResp(long lastModifyTimeForResp) {
        this.lastModifyTimeForResp = lastModifyTimeForResp;
    }

    public long getLastModifyTimeForFunction() {
        return this.lastModifyTimeForFunction;
    }

    public void setLastModifyTimeForFunction(long lastModifyTimeForFunction) {
        this.lastModifyTimeForFunction = lastModifyTimeForFunction;
    }

    public long getLastModifyTimeForUserRespMapping() {
        return this.lastModifyTimeForUserRespMapping;
    }

    public void setLastModifyTimeForUserRespMapping(long lastModifyTimeForUserRespMapping) {
        this.lastModifyTimeForUserRespMapping = lastModifyTimeForUserRespMapping;
    }
}

