/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.driver.VarnumAccessor;

public abstract class OracleStatement
implements oracle.jdbc.internal.OracleStatement,
ScrollRsetStatement {
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    static final byte IS_UNINITIALIZED = -1;
    static final byte IS_SELECT = 0;
    static final byte IS_PLSQL_BLOCK = 1;
    static final byte IS_DML = 2;
    static final byte IS_OTHER = 3;
    static final byte IS_CALL_BLOCK = 4;
    int cursorId;
    int number_of_define_positions;
    int defines_batch_size;
    Accessor[] accessors;
    int defineByteSubRange;
    int defineCharSubRange;
    int defineIndicatorSubRange;
    int defineLengthSubRange;
    byte[] defineBytes;
    char[] defineChars;
    short[] defineIndicators;
    boolean described = false;
    boolean describedWithNames = false;
    int rows_processed;
    OracleStatement children;
    OracleStatement nextChild;
    OracleStatement next;
    OracleStatement prev;
    long c_state;
    int number_of_bind_positions;
    byte[] bindBytes;
    char[] bindChars;
    short[] bindIndicators;
    int bindByteOffset;
    int bindCharOffset;
    int bindIndicatorOffset;
    int bindByteSubRange;
    int bindCharSubRange;
    int bindIndicatorSubRange;
    Accessor[] outBindAccessors;
    InputStream[][] parameterStream;
    boolean hasIbtBind = false;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    int ibtBindByteOffset;
    int ibtBindCharOffset;
    int ibtBindIndicatorOffset;
    int ibtBindIndicatorSize;
    byte[] tmpByteArray;
    int sizeTmpByteArray = 0;
    byte[] tmpBindsByteArray;
    boolean needToSendOalToFetch = false;
    int[] definedColumnType = null;
    int[] definedColumnSize = null;
    T4CTTIoac[] oacdefSent = null;
    char[][] charOutput = new char[1][];
    byte[][] byteOutput = new byte[1][];
    short[][] shortOutput = new short[1][];
    int accessorByteOffset = 0;
    int accessorCharOffset = 0;
    int accessorShortOffset = 0;
    static final int VALID_ROWS_UNINIT = -999;
    PhysicalConnection connection;
    OracleInputStream streamList;
    OracleInputStream nextStream;
    OracleResultSetImpl current_result_set;
    boolean process_escapes;
    int m_queryTimeout;
    int batch;
    int m_currentRank;
    int current_row;
    int valid_rows;
    int max_field_size;
    int max_rows;
    int total_rows_visited;
    int row_prefetch;
    int saved_rowPrefetch = -1;
    int default_row_prefetch;
    boolean row_prefetch_changed;
    boolean got_last_batch;
    boolean clear_params;
    boolean closed;
    boolean sql_string_changed;
    OracleSql m_sql;
    boolean need_to_parse;
    boolean need_to_prepare_define_buffer;
    boolean columns_defined_by_user;
    byte sql_kind;
    int auto_rollback;
    int default_fetch_direction;
    boolean m_autoRefetch;
    boolean serverCursor;
    boolean fixedString = false;
    boolean noMoreUpdateCounts = false;
    boolean m_isExecuting = false;
    static final byte EXECUTE_NONE = -1;
    static final byte EXECUTE_QUERY = 1;
    static final byte EXECUTE_UPDATE = 2;
    static final byte EXECUTE_NORMAL = 3;
    byte executionType = (byte)-1;
    OracleResultSet m_scrollRset;
    oracle.jdbc.OracleResultSetCache m_cache;
    int m_userRsetType;
    int m_realRsetType;
    boolean m_needToAddIdentifier;
    SQLWarning m_warning;
    int cacheState = 1;
    int m_creationState = 0;
    boolean m_isOpen = false;
    int statementType = 0;
    boolean columnSetNull = false;
    int last_index;
    Vector m_batchItems = new Vector();
    int CLOSE_CURRENT_RESULT = 1;
    int KEEP_CURRENT_RESULT = 2;
    int CLOSE_ALL_RESULTS = 3;
    int SUCCESS_NO_INFO = -2;
    int EXECUTE_FAILED = -3;
    int RETURN_GENERATED_KEYS = 1;
    int NO_GENERATED_KEYS = 2;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050624";

    OracleStatement(PhysicalConnection physicalConnection, int n, int n2) throws SQLException {
        this(physicalConnection, n, n2, -1, -1);
    }

    OracleStatement(PhysicalConnection physicalConnection, int n, int n2, int n3, int n4) throws SQLException {
        this.connection = physicalConnection;
        this.connection.needLine();
        this.connection.add_statement(this);
        this.m_sql = new OracleSql(this.connection.conversion);
        this.m_sql.isV8Compatible = this.connection.m_v8Compatible;
        this.process_escapes = this.connection.m_process_escapes;
        this.auto_rollback = 2;
        this.got_last_batch = false;
        this.closed = false;
        this.clear_params = true;
        this.serverCursor = false;
        this.m_needToAddIdentifier = false;
        this.default_fetch_direction = 1000;
        this.fixedString = this.connection.getDefaultFixedString();
        this.row_prefetch_changed = false;
        this.row_prefetch = n2;
        this.default_row_prefetch = n2;
        this.batch = n;
        this.m_autoRefetch = this.connection.getDefaultAutoRefetch();
        this.sql_string_changed = true;
        this.need_to_parse = true;
        this.need_to_prepare_define_buffer = true;
        this.columns_defined_by_user = false;
        if (n3 != -1 || n4 != -1) {
            this.m_realRsetType = 0;
            this.m_userRsetType = ResultSetUtil.getRsetTypeCode(n3, n4);
            this.m_needToAddIdentifier = ResultSetUtil.needIdentifier(this.m_userRsetType);
        } else {
            this.m_userRsetType = 1;
            this.m_realRsetType = 1;
        }
    }

    public synchronized void addBatch(String string) throws SQLException {
        this.addBatchItem(string);
    }

    void addBatchItem(String string) {
        this.m_batchItems.addElement(string);
    }

    void addChild(OracleStatement oracleStatement) {
        oracleStatement.nextChild = this.children;
        this.children = oracleStatement;
    }

    void adjustGotLastBatch() {
    }

    Accessor allocateAccessor(int n, int n2, int n3, int n4, short s, String string, boolean bl) throws SQLException {
        switch (n) {
            case 96: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new CharAccessor(this, n4, s, n2, bl);
            }
            case 8: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (!bl) {
                    return new LongAccessor(this, n3, n4, s, n2);
                }
            }
            case 1: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new VarcharAccessor(this, n4, s, n2, bl);
            }
            case 2: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new NumberAccessor(this, n4, s, n2, bl);
            }
            case 6: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new VarnumAccessor(this, n4, s, n2, bl);
            }
            case 24: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (!bl) {
                    return new LongRawAccessor(this, n3, n4, s, n2);
                }
            }
            case 23: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (bl) {
                    return new OutRawAccessor(this, n4, s, n2);
                }
                return new RawAccessor(this, n4, s, n2, false);
            }
            case 100: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BinaryFloatAccessor(this, n4, s, n2, bl);
            }
            case 101: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BinaryDoubleAccessor(this, n4, s, n2, bl);
            }
            case 104: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new RowidAccessor(this, n4, s, n2, bl);
            }
            case 102: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new ResultSetAccessor(this, n4, s, n2, bl);
            }
            case 12: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new DateAccessor(this, n4, s, n2, bl);
            }
            case 113: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BlobAccessor(this, n4, s, n2, bl);
            }
            case 112: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new ClobAccessor(this, n4, s, n2, bl);
            }
            case 114: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BfileAccessor(this, n4, s, n2, bl);
            }
            case 109: {
                if (string == null) {
                    if (bl) {
                        DatabaseError.throwSqlException(12, "sqlType=" + n2);
                    } else {
                        DatabaseError.throwSqlException(60, "Unable to resolve type \"null\"");
                    }
                }
                NamedTypeAccessor namedTypeAccessor = new NamedTypeAccessor(this, string, s, n2, bl);
                ((Accessor)namedTypeAccessor).initMetadata();
                return namedTypeAccessor;
            }
            case 111: {
                if (string == null) {
                    if (bl) {
                        DatabaseError.throwSqlException(12, "sqlType=" + n2);
                    } else {
                        DatabaseError.throwSqlException(60, "Unable to resolve type \"null\"");
                    }
                }
                RefTypeAccessor refTypeAccessor = new RefTypeAccessor(this, string, s, n2, bl);
                ((Accessor)refTypeAccessor).initMetadata();
                return refTypeAccessor;
            }
            case 180: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (this.connection.m_v8Compatible) {
                    return new DateAccessor(this, n4, s, n2, bl);
                }
                return new TimestampAccessor(this, n4, s, n2, bl);
            }
            case 181: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new TimestamptzAccessor(this, n4, s, n2, bl);
            }
            case 231: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new TimestampltzAccessor(this, n4, s, n2, bl);
            }
            case 182: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new IntervalymAccessor(this, n4, s, n2, bl);
            }
            case 183: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new IntervaldsAccessor(this, n4, s, n2, bl);
            }
            case 995: {
                DatabaseError.throwSqlException(89);
            }
        }
        DatabaseError.throwSqlException(4);
        return null;
    }

    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new RowidAccessor(this, 128, 1, -8, false);
    }

    void allocateTmpByteArray() {
    }

    protected void alwaysOnClose() throws SQLException {
        OracleStatement oracleStatement = this.children;
        while (oracleStatement != null) {
            OracleStatement oracleStatement2 = oracleStatement.nextChild;
            oracleStatement.close();
            oracleStatement = oracleStatement2;
        }
        this.closed = true;
        if (!this.connection.isClosed()) {
            this.connection.needLine();
            if (this.current_result_set != null) {
                this.current_result_set.internal_close(false);
                this.current_result_set = null;
            }
            if (this.m_scrollRset != null) {
                this.m_scrollRset.close();
                this.m_scrollRset = null;
            }
        }
        this.clearWarnings();
        this.m_batchItems = null;
    }

    public void cancel() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.connection.statement_holding_line != null) {
            this.freeLine();
        } else if (this.m_isExecuting) {
            this.connection.do_cancel();
        }
        this.connection.releaseLineForCancel();
    }

    boolean checkAccessorsUsable() throws SQLException {
        int n = this.accessors.length;
        if (n < this.number_of_define_positions) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < this.number_of_define_positions) {
            Accessor accessor = this.accessors[n2];
            if (accessor == null || accessor.external_type == 0) {
                bl = false;
            } else {
                bl2 = true;
            }
            ++n2;
        }
        if (bl) {
            bl3 = true;
        } else if (bl2) {
            DatabaseError.throwSqlException(21);
        } else {
            this.columns_defined_by_user = false;
        }
        return bl3;
    }

    void checkIfJdbcBatchExists() throws SQLException {
        if (this.getBatchSize() > 0) {
            DatabaseError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    void checkValidRowsStatus() throws SQLException {
        if (this.valid_rows == -2) {
            this.valid_rows = 1;
            this.connection.holdLine(this);
            OracleInputStream oracleInputStream = this.streamList;
            while (oracleInputStream != null) {
                if (oracleInputStream.hasBeenOpen) {
                    oracleInputStream = oracleInputStream.accessor.initForNewRow();
                }
                oracleInputStream.closed = false;
                oracleInputStream.hasBeenOpen = true;
                oracleInputStream = oracleInputStream.nextStream;
            }
            this.nextStream = this.streamList;
        } else if (this.sql_kind == 0) {
            if (this.valid_rows < this.row_prefetch) {
                this.got_last_batch = true;
            }
        } else if (this.sql_kind != 1 && this.sql_kind != 4) {
            this.rows_processed = this.valid_rows;
        }
    }

    void check_row_prefetch_changed() throws SQLException {
        if (this.row_prefetch_changed) {
            if (this.streamList == null) {
                this.prepareAccessors();
                this.need_to_prepare_define_buffer = true;
            }
            this.row_prefetch_changed = false;
        }
    }

    void cleanupDefines() {
        if (this.accessors != null) {
            int n = 0;
            while (n < this.accessors.length) {
                this.accessors[n] = null;
                ++n;
            }
        }
        this.accessors = null;
        if (this.defineBytes != null) {
            this.defineBytes = null;
        }
        if (this.defineChars != null) {
            this.defineChars = null;
        }
        if (this.defineIndicators != null) {
            this.defineIndicators = null;
        }
    }

    public synchronized void clearBatch() throws SQLException {
        this.clearBatchItems();
    }

    void clearBatchItems() {
        this.m_batchItems.removeAllElements();
    }

    public synchronized void clearDefines() throws SQLException {
        this.freeLine();
        this.streamList = null;
        this.columns_defined_by_user = false;
        this.need_to_prepare_define_buffer = true;
        this.number_of_define_positions = 0;
        this.defines_batch_size = 0;
        this.described = false;
        this.describedWithNames = false;
        this.cleanupDefines();
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.closeOrCache(null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void closeLeaveCursorOpen() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (this.closed) {
                    return;
                }
                this.hardClose(false);
            }
            return;
        }
    }

    protected void closeOrCache(String string) throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.statementType != 0 && this.cacheState != 0 && this.cacheState != 3 && this.connection.isStatementCacheInitialized()) {
            if (string == null) {
                if (this.connection.getImplicitCachingEnabled()) {
                    this.connection.cacheImplicitStatement((OraclePreparedStatement)this, this.m_sql.getOriginalSql(), this.statementType, this.m_userRsetType);
                } else {
                    this.cacheState = 0;
                    this.hardClose();
                }
            } else if (this.connection.getExplicitCachingEnabled()) {
                this.connection.cacheExplicitStatement((OraclePreparedStatement)this, string);
            } else {
                this.cacheState = 0;
                this.hardClose();
            }
        } else {
            this.hardClose();
        }
    }

    abstract void closeQuery() throws SQLException;

    void closeUsedStreams(int n) throws SQLException {
        while (this.nextStream != null && this.nextStream.columnIndex < n) {
            try {
                this.nextStream.close();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
            this.nextStream = this.nextStream.nextStream;
        }
    }

    public void closeWithKey(String string) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    void continueReadRow(int n) throws SQLException {
        throw new SQLException("continueReadRow is only implemented by the T4C statements.");
    }

    public int copyBinds(Statement statement, int n) throws SQLException {
        return 0;
    }

    public synchronized int creationState() {
        return this.m_creationState;
    }

    public synchronized void defineColumnType(int n, int n2) throws SQLException {
        this.defineColumnTypeInternal(n, n2, 0, true, null);
    }

    public void defineColumnType(int n, int n2, int n3) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, false, null);
    }

    public void defineColumnType(int n, int n2, int n3, short s) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, s, false, null);
    }

    public void defineColumnType(int n, int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.defineColumnTypeInternal(n, n2, 0, true, string);
            }
        }
    }

    public synchronized void defineColumnTypeBytes(int n, int n2, int n3) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, false, null);
    }

    public void defineColumnTypeChars(int n, int n2, int n3) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, false, null);
    }

    void defineColumnTypeInternal(int n, int n2, int n3, short s, boolean bl, String string) throws SQLException {
        int n4;
        if (this.connection.disableDefineColumnType) {
            return;
        }
        if (n < 1) {
            DatabaseError.throwSqlException(3);
        }
        if (n2 == 0) {
            DatabaseError.throwSqlException(4);
        }
        int n5 = n - 1;
        int n6 = this.max_field_size;
        if (bl) {
            if (n2 == 1 || n2 == 12) {
                this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 108);
            }
        } else {
            if (n3 < 0) {
                DatabaseError.throwSqlException(53);
            }
            if (n6 == 0 || n3 < n6) {
                n6 = n3;
            }
        }
        if (this.current_result_set != null && !this.current_result_set.closed) {
            DatabaseError.throwSqlException(28);
        }
        if (!this.columns_defined_by_user) {
            this.clearDefines();
            this.columns_defined_by_user = true;
        }
        if (this.number_of_define_positions < n) {
            if (this.accessors == null || this.accessors.length < n) {
                Accessor[] accessorArray = new Accessor[n << 1];
                if (this.accessors != null) {
                    System.arraycopy(this.accessors, 0, accessorArray, 0, this.number_of_define_positions);
                }
                this.accessors = accessorArray;
            }
            this.number_of_define_positions = n;
        }
        if (!((n4 = this.get_internal_type(n2)) != 109 && n4 != 111 || string != null && !string.equals(""))) {
            DatabaseError.check_error(60, "Invalid arguments");
        }
        Accessor accessor = this.accessors[n5];
        boolean bl2 = true;
        if (accessor != null) {
            int n7 = accessor.useForDataAccessIfPossible(n4, n2, n6, string);
            if (n7 == 0) {
                s = accessor.formOfUse;
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n7 == 1) {
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n7 == 2) {
                bl2 = false;
            }
        }
        if (bl2) {
            this.need_to_prepare_define_buffer = true;
        }
        if (accessor == null) {
            this.accessors[n5] = this.allocateAccessor(n4, n2, n, n6, s, string, false);
            this.described = false;
            this.describedWithNames = false;
        }
    }

    void defineColumnTypeInternal(int n, int n2, int n3, boolean bl, String string) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, (short)1, bl, string);
    }

    void describe() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (!this.described) {
                    this.connection.needLine();
                    this.do_describe(false);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doExecuteWithTimeout() throws SQLException {
        block18: {
            this.rows_processed = 0;
            if (this.sql_kind == 0) {
                if (this.connection.m_j2ee13Compliant && this.executionType == 2) {
                    DatabaseError.throwSqlException(129);
                }
                this.connection.needLine();
                if (!this.m_isOpen) {
                    this.connection.open(this);
                    this.m_isOpen = true;
                }
                if (!this.connection.getAutoCommit()) {
                    this.connection.switchTxnMode(0, 1);
                }
                this.connection.registerHeartbeat();
                if (this.m_queryTimeout != 0) {
                    try {
                        this.connection.getTimeout().setTimeout(this.m_queryTimeout * 1000, this);
                        this.execute_maybe_describe();
                    }
                    finally {
                        Object var2_1 = null;
                        this.connection.getTimeout().cancelTimeout();
                    }
                } else {
                    this.execute_maybe_describe();
                }
                this.checkValidRowsStatus();
                if (!this.serverCursor) return;
                this.adjustGotLastBatch();
                return;
            }
            if (this.connection.m_j2ee13Compliant && this.sql_kind != 1 && this.sql_kind != 4 && this.executionType == 1) {
                DatabaseError.throwSqlException(128);
            }
            ++this.m_currentRank;
            if (this.m_currentRank < this.batch) return;
            try {
                try {
                    this.connection.needLine();
                    if (!this.m_isOpen) {
                        this.connection.open(this);
                        this.m_isOpen = true;
                    }
                    if (!this.connection.getAutoCommit() && this.sql_kind == 2) {
                        this.connection.switchTxnMode(0, 1);
                    }
                    if (this.m_queryTimeout != 0) {
                        this.connection.getTimeout().setTimeout(this.m_queryTimeout * 1000, this);
                    }
                    this.m_isExecuting = true;
                    this.execute_for_rows(false);
                }
                catch (SQLException sQLException) {
                    this.need_to_parse = true;
                    throw sQLException;
                }
                Object var2_3 = null;
                if (this.m_queryTimeout == 0) break block18;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                if (this.m_queryTimeout != 0) {
                    this.connection.getTimeout().cancelTimeout();
                }
                this.m_currentRank = 0;
                this.m_isExecuting = false;
                this.checkValidRowsStatus();
                throw throwable;
            }
            this.connection.getTimeout().cancelTimeout();
        }
        this.m_currentRank = 0;
        this.m_isExecuting = false;
        this.checkValidRowsStatus();
        if (this.sql_kind != 3) return;
        this.connection.switchTxnMode(1, 0);
    }

    /*
     * Unable to fully structure code
     */
    void doScrollExecuteCommon() throws SQLException {
        block13: {
            if (this.m_scrollRset != null) {
                this.m_scrollRset.close();
                this.m_scrollRset = null;
            }
            if (this.sql_kind != 0) {
                this.doExecuteWithTimeout();
                return;
            }
            if (!this.m_needToAddIdentifier) {
                this.doExecuteWithTimeout();
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                this.m_realRsetType = this.m_userRsetType;
            } else {
                block14: {
                    try {
                        this.m_sql.setIncludeRowid(true);
                        this.need_to_parse = true;
                        this.prepare_for_new_result(true, false);
                        if (this.columns_defined_by_user) {
                            var1_1 = this.accessors;
                            if (this.accessors == null || this.accessors.length <= this.number_of_define_positions) {
                                this.accessors = new Accessor[this.number_of_define_positions + 1];
                            }
                            if (var1_1 != null) {
                                var2_3 = this.number_of_define_positions;
                                while (var2_3 > 0) {
                                    this.accessors[var2_3] = var3_5 = var1_1[var2_3 - 1];
                                    if (var3_5.isColumnNumberAware) {
                                        var3_5.updateColumnNumber(var2_3);
                                    }
                                    --var2_3;
                                }
                            }
                            this.allocateRowidAccessor();
                            ++this.number_of_define_positions;
                        }
                        this.doExecuteWithTimeout();
                        this.current_result_set = new OracleResultSetImpl(this.connection, this);
                        this.m_realRsetType = this.m_userRsetType;
                        break block13;
                    }
                    catch (SQLException var1_2) {
                        this.m_realRsetType = this.m_userRsetType > 3 ? 3 : 1;
                        this.m_sql.setIncludeRowid(false);
                        this.need_to_parse = true;
                        this.prepare_for_new_result(true, false);
                        if (!this.columns_defined_by_user) break block14;
                        this.need_to_prepare_define_buffer = true;
                        --this.number_of_define_positions;
                        System.arraycopy(this.accessors, 1, this.accessors, 0, this.number_of_define_positions);
                        this.accessors[this.number_of_define_positions] = null;
                        var2_4 = 0;
                        ** while (var2_4 < this.number_of_define_positions)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var3_6 = this.accessors[var2_4];
                        if (var3_6.isColumnNumberAware) {
                            var3_6.updateColumnNumber(var2_4);
                        }
                        ++var2_4;
                        continue;
                    }
                }
                this.doExecuteWithTimeout();
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 91, var1_2.getMessage());
            }
        }
        this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
    }

    OracleResultSet doScrollStmtExecuteQuery() throws SQLException {
        this.doScrollExecuteCommon();
        return this.m_scrollRset;
    }

    abstract void do_close() throws SQLException;

    abstract void do_describe(boolean var1) throws SQLException;

    void end_of_result_set(boolean bl) throws SQLException {
        if (!bl) {
            this.prepare_for_new_result(false, false);
        }
        this.clearDefines();
    }

    final void ensureOpen() throws SQLException {
        if (this.connection.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                boolean bl;
                try {
                    this.executionType = (byte)3;
                    this.noMoreUpdateCounts = false;
                    this.ensureOpen();
                    this.checkIfJdbcBatchExists();
                    this.sendBatch();
                    this.m_sql.initialize(string);
                    this.sql_kind = this.m_sql.getSqlKind();
                    this.need_to_parse = true;
                    this.prepare_for_new_result(true, true);
                    if (this.m_userRsetType == 1) {
                        this.doExecuteWithTimeout();
                    } else {
                        this.doScrollStmtExecuteQuery();
                    }
                    bl = this.sql_kind == 0;
                    Object var8_5 = null;
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    this.executionType = (byte)-1;
                    throw throwable;
                }
                this.executionType = (byte)-1;
                {
                }
                return bl;
            }
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                int[] nArray;
                block29: {
                    int n = 0;
                    int n2 = this.getBatchSize();
                    if (n2 <= 0) {
                        return new int[0];
                    }
                    nArray = new int[n2];
                    this.ensureOpen();
                    this.prepare_for_new_result(true, true);
                    int n3 = this.number_of_define_positions;
                    String string = this.m_sql.getOriginalSql();
                    byte by = this.sql_kind;
                    this.noMoreUpdateCounts = false;
                    int n4 = 0;
                    try {
                        try {
                            this.connection.needLine();
                            if (!this.connection.getAutoCommit() && this.sql_kind == 2) {
                                this.connection.switchTxnMode(0, 1);
                            }
                            n = 0;
                            while (true) {
                                int n5;
                                block28: {
                                    Object var17_16;
                                    if (n >= n2) {
                                        if (this.sql_kind == 3) {
                                            this.connection.switchTxnMode(1, 0);
                                        }
                                        break;
                                    }
                                    this.m_sql.initialize(this.getBatchItem(n));
                                    this.sql_kind = this.m_sql.getSqlKind();
                                    this.need_to_parse = true;
                                    this.number_of_define_positions = 0;
                                    this.rows_processed = 0;
                                    this.m_currentRank = 1;
                                    if (this.sql_kind == 0) {
                                        DatabaseError.throwBatchUpdateException(80, "invalid SELECT batch command " + n, n, nArray);
                                    }
                                    if (!this.m_isOpen) {
                                        this.connection.open(this);
                                        this.m_isOpen = true;
                                    }
                                    n5 = -1;
                                    try {
                                        try {
                                            if (this.m_queryTimeout != 0) {
                                                this.connection.getTimeout().setTimeout(this.m_queryTimeout * 1000, this);
                                            }
                                            this.m_isExecuting = true;
                                            this.execute_for_rows(false);
                                            if (this.valid_rows > 0) {
                                                n4 += this.valid_rows;
                                            }
                                            n5 = this.valid_rows;
                                        }
                                        catch (SQLException sQLException) {
                                            this.need_to_parse = true;
                                            throw sQLException;
                                        }
                                        var17_16 = null;
                                        if (this.m_queryTimeout == 0) break block28;
                                    }
                                    catch (Throwable throwable) {
                                        var17_16 = null;
                                        if (this.m_queryTimeout != 0) {
                                            this.connection.getTimeout().cancelTimeout();
                                        }
                                        this.valid_rows = n4;
                                        this.checkValidRowsStatus();
                                        this.m_isExecuting = false;
                                        throw throwable;
                                    }
                                    this.connection.getTimeout().cancelTimeout();
                                }
                                this.valid_rows = n4;
                                this.checkValidRowsStatus();
                                this.m_isExecuting = false;
                                nArray[n] = n5;
                                if (nArray[n] < 0) {
                                    DatabaseError.throwBatchUpdateException(81, "command return value " + nArray[n], n, nArray);
                                }
                                ++n;
                            }
                        }
                        catch (SQLException sQLException) {
                            if (sQLException instanceof BatchUpdateException) {
                                throw sQLException;
                            }
                            DatabaseError.throwBatchUpdateException(81, sQLException.getMessage(), n, nArray);
                        }
                        Object var14_21 = null;
                        this.clearBatchItems();
                        this.number_of_define_positions = n3;
                        if (string == null) break block29;
                    }
                    catch (Throwable throwable) {
                        Object var14_22 = null;
                        this.clearBatchItems();
                        this.number_of_define_positions = n3;
                        if (string != null) {
                            this.m_sql.initialize(string);
                            this.sql_kind = by;
                        }
                        this.m_currentRank = 0;
                        throw throwable;
                    }
                    this.m_sql.initialize(string);
                    this.sql_kind = by;
                }
                this.m_currentRank = 0;
                return nArray;
            }
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        OracleResultSet oracleResultSet = null;
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                block9: {
                    try {
                        this.executionType = 1;
                        this.noMoreUpdateCounts = false;
                        this.ensureOpen();
                        this.checkIfJdbcBatchExists();
                        this.sendBatch();
                        this.m_sql.initialize(string);
                        this.sql_kind = this.m_sql.getSqlKind();
                        this.need_to_parse = true;
                        this.prepare_for_new_result(true, true);
                        if (this.m_userRsetType == 1) {
                            this.doExecuteWithTimeout();
                            this.current_result_set = new OracleResultSetImpl(this.connection, this);
                            oracleResultSet = this.current_result_set;
                            break block9;
                        }
                        oracleResultSet = this.doScrollStmtExecuteQuery();
                        if (oracleResultSet != null) break block9;
                        this.current_result_set = new OracleResultSetImpl(this.connection, this);
                        oracleResultSet = this.current_result_set;
                    }
                    catch (Throwable throwable) {
                        Object var8_6 = null;
                        this.executionType = (byte)-1;
                        throw throwable;
                    }
                }
                Object var8_5 = null;
                this.executionType = (byte)-1;
            }
        }
        return oracleResultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                int n;
                try {
                    if (this.executionType == -1) {
                        this.executionType = (byte)2;
                    }
                    this.noMoreUpdateCounts = false;
                    this.ensureOpen();
                    this.checkIfJdbcBatchExists();
                    this.sendBatch();
                    this.m_sql.initialize(string);
                    this.sql_kind = this.m_sql.getSqlKind();
                    this.need_to_parse = true;
                    this.prepare_for_new_result(true, true);
                    if (this.m_userRsetType == 1) {
                        this.doExecuteWithTimeout();
                    } else {
                        this.doScrollStmtExecuteQuery();
                    }
                    n = this.valid_rows;
                    Object var8_5 = null;
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    this.executionType = (byte)-1;
                    throw throwable;
                }
                this.executionType = (byte)-1;
                {
                }
                return n;
            }
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    abstract void execute_for_describe() throws SQLException;

    abstract void execute_for_rows(boolean var1) throws SQLException;

    void execute_maybe_describe() throws SQLException {
        if (this.row_prefetch_changed) {
            if (this.streamList == null && this.row_prefetch != this.defines_batch_size) {
                this.need_to_prepare_define_buffer = true;
            }
            this.row_prefetch_changed = false;
        }
        if (!this.need_to_prepare_define_buffer) {
            if (this.accessors == null) {
                this.need_to_prepare_define_buffer = true;
            } else if (this.columns_defined_by_user) {
                this.need_to_prepare_define_buffer = this.checkAccessorsUsable() ^ true;
            }
        }
        boolean bl = false;
        try {
            try {
                this.m_isExecuting = true;
                if (this.need_to_prepare_define_buffer) {
                    if (!this.columns_defined_by_user) {
                        this.execute_for_describe();
                        bl = true;
                    }
                    this.prepareAccessors();
                }
                int n = this.accessors.length;
                int n2 = this.number_of_define_positions;
                while (n2 < n) {
                    Accessor accessor = this.accessors[n2];
                    if (accessor != null) {
                        accessor.rowSpaceIndicator = null;
                    }
                    ++n2;
                }
                this.execute_for_rows(bl);
            }
            catch (SQLException sQLException) {
                this.need_to_parse = true;
                throw sQLException;
            }
            Object var3_6 = null;
            this.m_isExecuting = false;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.m_isExecuting = false;
            throw throwable;
        }
    }

    abstract void fetch() throws SQLException;

    void freeLine() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    public boolean getAutoRefetch() throws SQLException {
        return this.m_autoRefetch;
    }

    String getBatchItem(int n) {
        return (String)this.m_batchItems.elementAt(n);
    }

    int getBatchSize() {
        return this.m_batchItems.size();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    Accessor[] getDescription() throws SQLException {
        if (!this.described) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.connection.needLine();
                    this.do_describe(false);
                    this.described = true;
                }
            }
        }
        return this.accessors;
    }

    Accessor[] getDescriptionWithNames() throws SQLException {
        if (!this.describedWithNames) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.connection.needLine();
                    this.do_describe(true);
                    this.described = true;
                    this.describedWithNames = true;
                }
            }
        }
        return this.accessors;
    }

    public int getFetchDirection() throws SQLException {
        return this.default_fetch_direction;
    }

    public int getFetchSize() throws SQLException {
        return this.getPrefetchInternal(true);
    }

    public boolean getFixedString() {
        return this.fixedString;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public int getMaxRows() throws SQLException {
        return this.max_rows;
    }

    public boolean getMoreResults() throws SQLException {
        this.connection.trace("Statement.getMoreResults");
        return false;
    }

    public boolean getMoreResults(int n) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return false;
    }

    int getNumberOfColumns() throws SQLException {
        if (!this.described) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.connection.needLine();
                    this.do_describe(false);
                    this.described = true;
                }
            }
        }
        return this.number_of_define_positions;
    }

    public String getOriginalSql() throws SQLException {
        return this.m_sql.getOriginalSql();
    }

    int getPrefetchInternal(boolean bl) {
        int n = bl ? this.default_row_prefetch : this.row_prefetch;
        return n;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        return this.m_queryTimeout;
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.connection.trace("Statement.getResultSet");
        if (this.m_userRsetType == 1) {
            if (this.sql_kind == 0) {
                if (this.current_result_set == null) {
                    this.current_result_set = new OracleResultSetImpl(this.connection, this);
                }
                return this.current_result_set;
            }
        } else {
            return this.m_scrollRset;
        }
        return null;
    }

    public synchronized OracleResultSetCache getResultSetCache() throws SQLException {
        return (OracleResultSetCache)this.m_cache;
    }

    public int getResultSetConcurrency() throws SQLException {
        return ResultSetUtil.getUpdateConcurrency(this.m_userRsetType);
    }

    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    public int getResultSetType() throws SQLException {
        return ResultSetUtil.getScrollType(this.m_userRsetType);
    }

    public String getRevisedSql() throws SQLException {
        return this.m_sql.getRevisedSql();
    }

    public synchronized int getRowPrefetch() {
        return this.getPrefetchInternal(true);
    }

    byte getSqlKind() {
        return this.sql_kind;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.connection.trace("Statement.getUpdateCount");
        int n = -1;
        switch (this.sql_kind) {
            case 3: {
                if (!this.noMoreUpdateCounts) {
                    n = this.rows_processed;
                }
                this.noMoreUpdateCounts = true;
                break;
            }
            case 1: {
                this.noMoreUpdateCounts = true;
                break;
            }
            case 2: {
                if (!this.noMoreUpdateCounts) {
                    n = this.rows_processed;
                }
                this.noMoreUpdateCounts = true;
                break;
            }
        }
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warning;
    }

    int get_column_index(String string) throws SQLException {
        if (!this.describedWithNames) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.connection.needLine();
                    this.do_describe(true);
                    this.described = true;
                    this.describedWithNames = true;
                }
            }
        }
        int n = 0;
        while (n < this.number_of_define_positions) {
            if (this.accessors[n].columnName.equalsIgnoreCase(string)) {
                return n + 1;
            }
            ++n;
        }
        DatabaseError.throwSqlException(6);
        return 0;
    }

    int get_internal_type(int n) throws SQLException {
        int n2 = 0;
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 6;
                break;
            }
            case 100: {
                n2 = 100;
                break;
            }
            case 101: {
                n2 = 101;
                break;
            }
            case 999: {
                n2 = 999;
                break;
            }
            case 1: {
                n2 = 96;
                break;
            }
            case 12: {
                n2 = 1;
                break;
            }
            case -1: {
                n2 = 8;
                break;
            }
            case 91: 
            case 92: {
                n2 = 12;
                break;
            }
            case -100: 
            case 93: {
                n2 = 180;
                break;
            }
            case -101: {
                n2 = 181;
                break;
            }
            case -102: {
                n2 = 231;
                break;
            }
            case -103: {
                n2 = 182;
                break;
            }
            case -104: {
                n2 = 183;
                break;
            }
            case -3: 
            case -2: {
                n2 = 23;
                break;
            }
            case -4: {
                n2 = 24;
                break;
            }
            case -8: {
                n2 = 104;
                break;
            }
            case 2004: {
                n2 = 113;
                break;
            }
            case 2005: {
                n2 = 112;
                break;
            }
            case -13: {
                n2 = 114;
                break;
            }
            case -10: {
                n2 = 102;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                n2 = 109;
                break;
            }
            case 2006: {
                n2 = 111;
                break;
            }
            case -14: {
                n2 = 998;
                break;
            }
            case 70: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 995;
                break;
            }
            default: {
                DatabaseError.throwSqlException(4);
                n2 = 0;
            }
        }
        return n2;
    }

    public int getcacheState() {
        return this.cacheState;
    }

    public boolean getserverCursor() {
        return this.serverCursor;
    }

    public int getstatementType() {
        return this.statementType;
    }

    protected void hardClose() throws SQLException {
        this.hardClose(true);
    }

    private void hardClose(boolean bl) throws SQLException {
        this.alwaysOnClose();
        this.describedWithNames = false;
        this.described = false;
        this.connection.remove_statement(this);
        this.cleanupDefines();
        if (this.m_isOpen && bl && !this.connection.isClosed()) {
            this.do_close();
            this.m_isOpen = false;
        }
        this.m_sql = null;
    }

    void initBatch() {
    }

    void initializeDefineSubRanges() {
        this.defineByteSubRange = 0;
        this.defineCharSubRange = 0;
        this.defineIndicatorSubRange = 0;
    }

    public boolean isColumnSetNull(int n) {
        return this.columnSetNull;
    }

    public boolean isNCHAR(int n) throws SQLException {
        if (!this.described) {
            this.describe();
        }
        if (n < 0 || n >= this.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        boolean bl = this.accessors[n].formOfUse == 2;
        return bl;
    }

    public void notify_close_rset() throws SQLException {
        this.m_scrollRset = null;
        this.end_of_result_set(false);
    }

    void open() throws SQLException {
        if (!this.m_isOpen) {
            this.connection.needLine();
            this.connection.open(this);
            this.m_isOpen = true;
        }
    }

    void prepareAccessors() throws SQLException {
        int n;
        Accessor accessor;
        byte[] byArray = null;
        char[] cArray = null;
        short[] sArray = null;
        boolean bl = false;
        if (this.accessors == null) {
            DatabaseError.throwSqlException(21);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.number_of_define_positions) {
            accessor = this.accessors[n4];
            if (accessor == null) {
                DatabaseError.throwSqlException(21);
            }
            n2 += accessor.byteLength;
            n3 += accessor.charLength;
            ++n4;
        }
        if (this.streamList != null && !this.connection.useFetchSizeWithLongColumn) {
            this.row_prefetch = 1;
        }
        this.defines_batch_size = n = this.row_prefetch;
        this.initializeDefineSubRanges();
        int n5 = this.defineByteSubRange + n2 * n;
        if (this.defineBytes == null || this.defineBytes.length < n5) {
            if (this.defineBytes != null) {
                byArray = this.defineBytes;
            }
            this.defineBytes = new byte[n5];
        }
        this.defineByteSubRange += this.accessorByteOffset;
        int n6 = this.defineCharSubRange + n3 * n;
        if ((this.defineChars == null || this.defineChars.length < n6) && n6 > 0) {
            if (this.defineChars != null) {
                cArray = this.defineChars;
            }
            this.defineChars = new char[n6];
        }
        this.defineCharSubRange += this.accessorCharOffset;
        int n7 = this.number_of_define_positions * n;
        int n8 = this.defineIndicatorSubRange + n7 + n7;
        if (this.defineIndicators == null || this.defineIndicators.length < n8) {
            if (this.defineIndicators != null) {
                sArray = this.defineIndicators;
            }
            this.defineIndicators = new short[n8];
        } else if (this.defineIndicators.length > n8) {
            bl = true;
            sArray = this.defineIndicators;
        }
        this.defineIndicatorSubRange += this.accessorShortOffset;
        int n9 = this.defineIndicatorSubRange + n7;
        int n10 = 0;
        while (n10 < this.number_of_define_positions) {
            accessor = this.accessors[n10];
            accessor.lengthIndexLastRow = accessor.lengthIndex;
            accessor.indicatorIndexLastRow = accessor.indicatorIndex;
            accessor.columnIndexLastRow = accessor.columnIndex;
            accessor.setOffsets(n);
            accessor.lengthIndex = n9;
            accessor.indicatorIndex = this.defineIndicatorSubRange;
            accessor.rowSpaceByte = this.defineBytes;
            accessor.rowSpaceChar = this.defineChars;
            accessor.rowSpaceIndicator = this.defineIndicators;
            this.defineIndicatorSubRange += n;
            n9 += n;
            ++n10;
        }
        this.prepareDefinePreambles();
        if (cArray != null || byArray != null) {
            this.saveDefineBuffersIfRequired(cArray, byArray, sArray != null ? sArray : this.defineIndicators, bl);
        } else if (bl && this.saved_rowPrefetch != -1 && this.row_prefetch != this.saved_rowPrefetch) {
            this.saveDefineBuffersIfRequired(this.defineChars, this.defineBytes, this.defineIndicators, bl);
        }
        this.saved_rowPrefetch = -1;
    }

    void prepareDefinePreambles() {
    }

    void prepare_for_new_result(boolean bl, boolean bl2) throws SQLException {
        this.clearWarnings();
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
            if (bl2) {
                OracleInputStream oracleInputStream = this.streamList;
                OracleInputStream oracleInputStream2 = null;
                this.streamList = null;
                while (oracleInputStream != null) {
                    if (!oracleInputStream.hasBeenOpen) {
                        if (oracleInputStream2 == null) {
                            this.streamList = oracleInputStream;
                        } else {
                            oracleInputStream2.nextStream = oracleInputStream;
                        }
                        oracleInputStream2 = oracleInputStream;
                    }
                    oracleInputStream = oracleInputStream.nextStream;
                }
            }
        }
        if (this.current_result_set != null) {
            this.current_result_set.internal_close(true);
            this.current_result_set = null;
        }
        this.current_row = -1;
        this.valid_rows = 0;
        this.total_rows_visited = 0;
        this.got_last_batch = false;
        if (this.need_to_parse && !this.columns_defined_by_user) {
            if (bl2 && this.number_of_define_positions != 0) {
                this.number_of_define_positions = 0;
            }
            this.need_to_prepare_define_buffer = true;
        }
        if (bl && this.row_prefetch != this.default_row_prefetch && this.streamList == null) {
            this.row_prefetch = this.default_row_prefetch;
            this.row_prefetch_changed = true;
        }
    }

    void printState(String string) throws SQLException {
    }

    void reopenStreams() throws SQLException {
        OracleInputStream oracleInputStream = this.streamList;
        while (oracleInputStream != null) {
            if (oracleInputStream.hasBeenOpen) {
                oracleInputStream = oracleInputStream.accessor.initForNewRow();
            }
            oracleInputStream.closed = false;
            oracleInputStream.hasBeenOpen = true;
            oracleInputStream = oracleInputStream.nextStream;
        }
        this.nextStream = this.streamList;
    }

    void reparseOnRedefineIfNeeded() throws SQLException {
    }

    void saveDefineBuffersIfRequired(char[] cArray, byte[] byArray, short[] sArray, boolean bl) throws SQLException {
    }

    public int sendBatch() throws SQLException {
        return 0;
    }

    public void setAutoRefetch(boolean bl) throws SQLException {
        this.m_autoRefetch = bl;
    }

    void setCursorId(int n) throws SQLException {
        this.cursorId = n;
    }

    public void setCursorName(String string) throws SQLException {
        this.connection.trace("Statement.setCursorName");
        DatabaseError.throwSqlException(23);
    }

    void setDefinesInitialized(boolean bl) {
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.connection.trace("Statement.setEscapeProcessing");
        this.process_escapes = bl;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n == 1000) {
            this.default_fetch_direction = n;
        } else if (n == 1001 || n == 1002) {
            this.default_fetch_direction = 1000;
            this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 87);
        } else {
            DatabaseError.throwSqlException(68, "setFetchDirection");
        }
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.setPrefetchInternal(n, false, true);
    }

    public void setFixedString(boolean bl) {
        this.fixedString = bl;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        }
        this.max_field_size = n;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        }
        this.max_rows = n;
    }

    void setPrefetchInternal(int n, boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            if (n <= 0) {
                DatabaseError.throwSqlException(20);
            }
        } else if (n < 0) {
            DatabaseError.throwSqlException(68, "setFetchSize");
        } else if (n == 0) {
            n = this.connection.getDefaultRowPrefetch();
        }
        if (bl2) {
            if (n != this.default_row_prefetch) {
                this.saved_rowPrefetch = this.row_prefetch;
                this.default_row_prefetch = n;
                if (this.current_result_set == null || this.current_result_set.closed) {
                    this.row_prefetch_changed = true;
                }
            }
        } else if (n != this.row_prefetch && this.streamList == null) {
            this.saved_rowPrefetch = this.row_prefetch;
            this.row_prefetch = n;
            this.row_prefetch_changed = true;
        }
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        }
        this.m_queryTimeout = n;
    }

    public synchronized void setResultSetCache(oracle.jdbc.OracleResultSetCache oracleResultSetCache) throws SQLException {
        try {
            if (oracleResultSetCache == null) {
                DatabaseError.throwSqlException(68);
            }
            if (this.m_cache != null) {
                this.m_cache.close();
            }
            this.m_cache = oracleResultSetCache;
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized void setResultSetCache(OracleResultSetCache oracleResultSetCache) throws SQLException {
        this.setResultSetCache((oracle.jdbc.OracleResultSetCache)oracleResultSetCache);
    }

    public synchronized void setRowPrefetch(int n) throws SQLException {
        this.setPrefetchInternal(n, true, true);
    }

    boolean wasNullValue() throws SQLException {
        if (this.last_index == 0) {
            DatabaseError.throwSqlException(24);
        }
        if (this.sql_kind == 0) {
            return this.accessors[this.last_index - 1].isNull(this.current_row);
        }
        return this.outBindAccessors[this.last_index - 1].isNull(this.m_currentRank);
    }
}

