/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;
import oracle.sql.converter.CharacterSetMetaData;

public class SQLUtil {
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050624";
    private static final int CLASS_NOT_FOUND = -1;
    private static final int CLASS_STRING = 0;
    private static final int CLASS_BOOLEAN = 1;
    private static final int CLASS_INTEGER = 2;
    private static final int CLASS_LONG = 3;
    private static final int CLASS_FLOAT = 4;
    private static final int CLASS_DOUBLE = 5;
    private static final int CLASS_BIGDECIMAL = 6;
    private static final int CLASS_DATE = 7;
    private static final int CLASS_TIME = 8;
    private static final int CLASS_TIMESTAMP = 9;
    private static final int TOTAL_CLASSES = 10;
    private static Hashtable s_classTbl = new Hashtable(10);

    static {
        try {
            s_classTbl.put(Class.forName("java.lang.String"), new Integer(0));
            s_classTbl.put(Class.forName("java.lang.Boolean"), new Integer(1));
            s_classTbl.put(Class.forName("java.lang.Integer"), new Integer(2));
            s_classTbl.put(Class.forName("java.lang.Long"), new Integer(3));
            s_classTbl.put(Class.forName("java.lang.Float"), new Integer(4));
            s_classTbl.put(Class.forName("java.lang.Double"), new Integer(5));
            s_classTbl.put(Class.forName("java.math.BigDecimal"), new Integer(6));
            s_classTbl.put(Class.forName("java.sql.Date"), new Integer(7));
            s_classTbl.put(Class.forName("java.sql.Time"), new Integer(8));
            s_classTbl.put(Class.forName("java.sql.Timestamp"), new Integer(9));
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public static byte[] JavaToSQL(OracleConnection oracleConnection, Object object, int n, String string) throws SQLException {
        if (object == null) {
            return null;
        }
        Datum datum = null;
        if (object instanceof Datum) {
            datum = (Datum)object;
        } else if (object instanceof ORAData) {
            datum = ((ORAData)object).toDatum(oracleConnection);
        } else if (object instanceof CustomDatum) {
            datum = oracleConnection.toDatum((CustomDatum)object);
        } else if (object instanceof SQLData) {
            datum = STRUCT.toSTRUCT(object, oracleConnection);
        }
        if (datum != null) {
            if (!SQLUtil.checkDatumType(datum, n, string)) {
                datum = null;
            }
        } else {
            datum = SQLUtil.makeDatum(oracleConnection, object, n, string);
        }
        byte[] byArray = null;
        if (datum != null) {
            byArray = datum instanceof STRUCT ? ((STRUCT)datum).toBytes() : (datum instanceof ARRAY ? ((ARRAY)datum).toBytes() : (datum instanceof OPAQUE ? ((OPAQUE)datum).toBytes() : datum.shareBytes()));
        } else {
            DatabaseError.check_error(1, "attempt to convert a Datum to incompatible SQL type");
        }
        return byArray;
    }

    public static Object SQLToJava(OracleConnection oracleConnection, Datum datum, Class clazz, Map map) throws SQLException {
        Object object = null;
        if (datum instanceof STRUCT) {
            object = clazz == null ? (map != null ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc()) : (map != null ? ((STRUCT)datum).toClass(clazz, map) : ((STRUCT)datum).toClass(clazz));
        } else if (clazz == null) {
            object = datum.toJdbc();
        } else {
            int n = SQLUtil.classNumber(clazz);
            switch (n) {
                case 0: {
                    object = datum.stringValue();
                    break;
                }
                case 1: {
                    object = new Boolean(datum.longValue() != 0L);
                    break;
                }
                case 2: {
                    object = new Integer((int)datum.longValue());
                    break;
                }
                case 3: {
                    object = new Long(datum.longValue());
                    break;
                }
                case 4: {
                    object = new Float(datum.bigDecimalValue().floatValue());
                    break;
                }
                case 5: {
                    object = new Double(datum.bigDecimalValue().doubleValue());
                    break;
                }
                case 6: {
                    object = datum.bigDecimalValue();
                    break;
                }
                case 7: {
                    object = datum.dateValue();
                    break;
                }
                case 8: {
                    object = datum.timeValue();
                    break;
                }
                case 9: {
                    object = datum.timestampValue();
                    break;
                }
                default: {
                    object = datum.toJdbc();
                    if (clazz.isInstance(object)) break;
                    DatabaseError.check_error(59, "invalid data conversion");
                    break;
                }
            }
        }
        return object;
    }

    public static Object SQLToJava(OracleConnection oracleConnection, byte[] byArray, int n, String string, Class clazz, Map map) throws SQLException {
        Datum datum = SQLUtil.makeDatum(oracleConnection, byArray, n, string, 0);
        Object object = SQLUtil.SQLToJava(oracleConnection, datum, clazz, map);
        return object;
    }

    public static CustomDatum SQLToJava(OracleConnection oracleConnection, byte[] byArray, int n, String string, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = SQLUtil.makeDatum(oracleConnection, byArray, n, string, 0);
        CustomDatum customDatum = customDatumFactory.create(datum, n);
        return customDatum;
    }

    public static ORAData SQLToJava(OracleConnection oracleConnection, byte[] byArray, int n, String string, ORADataFactory oRADataFactory) throws SQLException {
        Datum datum = SQLUtil.makeDatum(oracleConnection, byArray, n, string, 0);
        ORAData oRAData = oRADataFactory.create(datum, n);
        return oRAData;
    }

    public static boolean checkDatumType(Datum datum, int n, String string) throws SQLException {
        boolean bl = false;
        switch (n) {
            case 1: 
            case 8: 
            case 96: {
                bl = datum instanceof CHAR;
                break;
            }
            case 2: 
            case 6: {
                bl = datum instanceof NUMBER;
                break;
            }
            case 100: {
                bl = datum instanceof BINARY_FLOAT;
                break;
            }
            case 101: {
                bl = datum instanceof BINARY_DOUBLE;
                break;
            }
            case 23: 
            case 24: {
                bl = datum instanceof RAW;
                break;
            }
            case 104: {
                bl = datum instanceof ROWID;
                break;
            }
            case 12: {
                bl = datum instanceof DATE;
                break;
            }
            case 180: {
                bl = datum instanceof TIMESTAMP;
                break;
            }
            case 181: {
                bl = datum instanceof TIMESTAMPTZ;
                break;
            }
            case 231: {
                bl = datum instanceof TIMESTAMPLTZ;
                break;
            }
            case 113: {
                bl = datum instanceof BLOB;
                break;
            }
            case 112: {
                bl = datum instanceof CLOB;
                break;
            }
            case 114: {
                bl = datum instanceof BFILE;
                break;
            }
            case 111: {
                bl = datum instanceof REF && ((REF)datum).getBaseTypeName().equals(string);
                break;
            }
            case 109: {
                if (datum instanceof STRUCT) {
                    bl = ((STRUCT)datum).isInHierarchyOf(string);
                    break;
                }
                if (datum instanceof ARRAY) {
                    bl = ((ARRAY)datum).getSQLTypeName().equals(string);
                    break;
                }
                if (!(datum instanceof OPAQUE)) break;
                bl = ((OPAQUE)datum).getSQLTypeName().equals(string);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static int classNumber(Class clazz) {
        int n = -1;
        Integer n2 = (Integer)s_classTbl.get(clazz);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public static Object getTypeDescriptor(String string, OracleConnection oracleConnection) throws SQLException {
        Object object = null;
        SQLName sQLName = new SQLName(string, oracleConnection);
        String string2 = sQLName.getName();
        object = oracleConnection.getDescriptor(string2);
        if (object != null) {
            return object;
        }
        OracleTypeADT oracleTypeADT = new OracleTypeADT(string2, (Connection)oracleConnection);
        oracleConnection.getOracleTypeADT(oracleTypeADT);
        oracleTypeADT.init(oracleConnection);
        OracleNamedType oracleNamedType = oracleTypeADT.cleanup();
        switch (oracleNamedType.getTypeCode()) {
            case 2003: {
                object = new ArrayDescriptor(sQLName, (OracleTypeCOLLECTION)oracleNamedType, (Connection)oracleConnection);
                break;
            }
            case 2002: 
            case 2008: {
                object = new StructDescriptor(sQLName, (OracleTypeADT)oracleNamedType, oracleConnection);
                break;
            }
            case 2007: {
                object = new OpaqueDescriptor(sQLName, (OracleTypeOPAQUE)oracleNamedType, (Connection)oracleConnection);
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "Unrecognized type code");
            }
        }
        oracleConnection.putDescriptor(string2, object);
        return object;
    }

    public static int get_internal_type(int n) throws SQLException {
        int n2 = 0;
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 6;
                break;
            }
            case 100: {
                n2 = 100;
                break;
            }
            case 101: {
                n2 = 101;
                break;
            }
            case 999: {
                n2 = 999;
                break;
            }
            case 1: {
                n2 = 96;
                break;
            }
            case 12: {
                n2 = 1;
                break;
            }
            case -1: {
                n2 = 8;
                break;
            }
            case 91: 
            case 92: {
                n2 = 12;
                break;
            }
            case -100: 
            case 93: {
                n2 = 180;
                break;
            }
            case -101: {
                n2 = 181;
                break;
            }
            case -102: {
                n2 = 231;
                break;
            }
            case -104: {
                n2 = 183;
                break;
            }
            case -103: {
                n2 = 182;
                break;
            }
            case -3: 
            case -2: {
                n2 = 23;
                break;
            }
            case -4: {
                n2 = 24;
                break;
            }
            case -8: {
                n2 = 104;
                break;
            }
            case 2004: {
                n2 = 113;
                break;
            }
            case 2005: {
                n2 = 112;
                break;
            }
            case -13: {
                n2 = 114;
                break;
            }
            case -10: {
                n2 = 102;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                n2 = 109;
                break;
            }
            case 2006: {
                n2 = 111;
                break;
            }
            default: {
                DatabaseError.check_error(4, "get_internal_type");
            }
        }
        return n2;
    }

    public static boolean implementsInterface(Class clazz, Class clazz2) {
        if (clazz == null) {
            return false;
        }
        if (clazz == clazz2) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (SQLUtil.implementsInterface(classArray[n], clazz2)) {
                return true;
            }
            ++n;
        }
        return SQLUtil.implementsInterface(clazz.getSuperclass(), clazz2);
    }

    public static Datum makeDatum(OracleConnection oracleConnection, Object object, int n, String string) throws SQLException {
        Datum datum = null;
        switch (n) {
            case 1: 
            case 8: 
            case 96: {
                datum = new CHAR(object, CharacterSet.make(oracleConnection.getJdbcCsId()));
                break;
            }
            case 2: 
            case 6: {
                datum = new NUMBER(object);
                break;
            }
            case 100: {
                datum = new BINARY_FLOAT((Float)object);
                break;
            }
            case 101: {
                datum = new BINARY_DOUBLE((Double)object);
                break;
            }
            case 23: 
            case 24: {
                datum = new RAW(object);
                break;
            }
            case 104: {
                datum = new ROWID((byte[])object);
                break;
            }
            case 102: {
                DatabaseError.check_error(1, "need resolution: do we want to handle ResultSet");
                break;
            }
            case 12: {
                datum = new DATE(object);
                break;
            }
            case 180: {
                if (object instanceof TIMESTAMP) {
                    datum = (Datum)object;
                    break;
                }
                if (object instanceof Timestamp) {
                    datum = new TIMESTAMP((Timestamp)object);
                    break;
                }
                if (object instanceof Date) {
                    datum = new TIMESTAMP((Date)object);
                    break;
                }
                if (object instanceof Time) {
                    datum = new TIMESTAMP((Time)object);
                    break;
                }
                if (object instanceof DATE) {
                    datum = new TIMESTAMP((DATE)object);
                    break;
                }
                if (object instanceof String) {
                    datum = new TIMESTAMP((String)object);
                    break;
                }
                if (!(object instanceof byte[])) break;
                datum = new TIMESTAMP((byte[])object);
                break;
            }
            case 181: {
                if (object instanceof TIMESTAMPTZ) {
                    datum = (Datum)object;
                    break;
                }
                if (object instanceof Timestamp) {
                    datum = new TIMESTAMPTZ((Connection)oracleConnection, (Timestamp)object);
                    break;
                }
                if (object instanceof Date) {
                    datum = new TIMESTAMPTZ((Connection)oracleConnection, (Date)object);
                    break;
                }
                if (object instanceof Time) {
                    datum = new TIMESTAMPTZ((Connection)oracleConnection, (Time)object);
                    break;
                }
                if (object instanceof DATE) {
                    datum = new TIMESTAMPTZ((Connection)oracleConnection, (DATE)object);
                    break;
                }
                if (object instanceof String) {
                    datum = new TIMESTAMPTZ((Connection)oracleConnection, (String)object);
                    break;
                }
                if (!(object instanceof byte[])) break;
                datum = new TIMESTAMPTZ((byte[])object);
                break;
            }
            case 231: {
                if (object instanceof TIMESTAMPLTZ) {
                    datum = (Datum)object;
                    break;
                }
                if (object instanceof Timestamp) {
                    datum = new TIMESTAMPLTZ((Connection)oracleConnection, (Timestamp)object);
                    break;
                }
                if (object instanceof Date) {
                    datum = new TIMESTAMPLTZ((Connection)oracleConnection, (Date)object);
                    break;
                }
                if (object instanceof Time) {
                    datum = new TIMESTAMPLTZ((Connection)oracleConnection, (Time)object);
                    break;
                }
                if (object instanceof DATE) {
                    datum = new TIMESTAMPLTZ((Connection)oracleConnection, (DATE)object);
                    break;
                }
                if (object instanceof String) {
                    datum = new TIMESTAMPLTZ((Connection)oracleConnection, (String)object);
                    break;
                }
                if (!(object instanceof byte[])) break;
                datum = new TIMESTAMPLTZ((byte[])object);
                break;
            }
            case 113: {
                if (!(object instanceof BLOB)) break;
                datum = (Datum)object;
                break;
            }
            case 112: {
                if (!(object instanceof CLOB)) break;
                datum = (Datum)object;
                break;
            }
            case 114: {
                if (!(object instanceof BFILE)) break;
                datum = (Datum)object;
                break;
            }
            case 109: {
                if (!(object instanceof STRUCT) && !(object instanceof ARRAY) && !(object instanceof OPAQUE)) break;
                datum = (Datum)object;
                break;
            }
            case 111: {
                if (!(object instanceof REF)) break;
                datum = (Datum)object;
                break;
            }
        }
        if (datum == null) {
            DatabaseError.check_error(1, "Unable to construct a Datum from the specified input");
        }
        return datum;
    }

    public static Datum makeDatum(OracleConnection oracleConnection, byte[] byArray, int n, String string, int n2) throws SQLException {
        Datum datum = null;
        short s = oracleConnection.getDbCsId();
        int n3 = CharacterSetMetaData.getRatio(s, 1);
        switch (n) {
            case 96: {
                if (n2 != 0 && n2 < byArray.length && n3 == 1) {
                    datum = new CHAR(byArray, 0, n2, CharacterSet.make(oracleConnection.getJdbcCsId()));
                    break;
                }
                datum = new CHAR(byArray, CharacterSet.make(oracleConnection.getJdbcCsId()));
                break;
            }
            case 1: 
            case 8: {
                datum = new CHAR(byArray, CharacterSet.make(oracleConnection.getJdbcCsId()));
                break;
            }
            case 2: 
            case 6: {
                datum = new NUMBER(byArray);
                break;
            }
            case 100: {
                datum = new BINARY_FLOAT(byArray);
                break;
            }
            case 101: {
                datum = new BINARY_DOUBLE(byArray);
                break;
            }
            case 23: 
            case 24: {
                datum = new RAW(byArray);
                break;
            }
            case 104: {
                datum = new ROWID(byArray);
                break;
            }
            case 102: {
                DatabaseError.check_error(1, "need resolution: do we want to handle ResultSet?");
                break;
            }
            case 12: {
                datum = new DATE(byArray);
                break;
            }
            case 182: {
                datum = new INTERVALYM(byArray);
                break;
            }
            case 183: {
                datum = new INTERVALDS(byArray);
                break;
            }
            case 180: {
                datum = new TIMESTAMP(byArray);
                break;
            }
            case 181: {
                datum = new TIMESTAMPTZ(byArray);
                break;
            }
            case 231: {
                datum = new TIMESTAMPLTZ(byArray);
                break;
            }
            case 113: {
                datum = oracleConnection.createBlob(byArray);
                break;
            }
            case 112: {
                datum = oracleConnection.createClob(byArray);
                break;
            }
            case 114: {
                datum = oracleConnection.createBfile(byArray);
                break;
            }
            case 109: {
                TypeDescriptor typeDescriptor = TypeDescriptor.getTypeDescriptor(string, oracleConnection, byArray, 0L);
                if (typeDescriptor instanceof StructDescriptor) {
                    datum = new STRUCT((StructDescriptor)typeDescriptor, byArray, oracleConnection);
                    break;
                }
                if (typeDescriptor instanceof ArrayDescriptor) {
                    datum = new ARRAY((ArrayDescriptor)typeDescriptor, byArray, oracleConnection);
                    break;
                }
                if (!(typeDescriptor instanceof OpaqueDescriptor)) break;
                datum = new OPAQUE((OpaqueDescriptor)typeDescriptor, byArray, oracleConnection);
                break;
            }
            case 111: {
                Object object = SQLUtil.getTypeDescriptor(string, oracleConnection);
                if (object instanceof StructDescriptor) {
                    datum = new REF((StructDescriptor)object, (Connection)oracleConnection, byArray);
                    break;
                }
                DatabaseError.check_error(1, "program error: REF points to a non-STRUCT");
                break;
            }
            default: {
                DatabaseError.check_error(1, "program error: invalid SQL type code");
            }
        }
        return datum;
    }

    public static Datum makeNDatum(OracleConnection oracleConnection, byte[] byArray, int n, String string, short s, int n2) throws SQLException {
        Datum datum = null;
        switch (n) {
            case 96: {
                int n3 = n2 * CharacterSetMetaData.getRatio(oracleConnection.getNCharSet(), 1);
                if (n2 != 0 && n3 < byArray.length) {
                    datum = new CHAR(byArray, 0, n2, CharacterSet.make(oracleConnection.getNCharSet()));
                    break;
                }
                datum = new CHAR(byArray, CharacterSet.make(oracleConnection.getNCharSet()));
                break;
            }
            case 1: 
            case 8: {
                datum = new CHAR(byArray, CharacterSet.make(oracleConnection.getNCharSet()));
                break;
            }
            case 112: {
                datum = oracleConnection.createClob(byArray, s);
                break;
            }
            default: {
                DatabaseError.check_error(1, "program error: invalid SQL type code");
            }
        }
        return datum;
    }

    public static Datum makeOracleDatum(OracleConnection oracleConnection, Object object, int n, String string) throws SQLException {
        Datum datum = SQLUtil.makeDatum(oracleConnection, object, SQLUtil.get_internal_type(n), string);
        return datum;
    }
}

