/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.T4C8TTIrxh;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIdcb;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIiov;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4CTTIoexec;
import oracle.jdbc.driver.T4CTTIofetch;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.net.ns.BreakNetException;

class T4C8Oall
extends T4CTTIfun {
    static final byte[] EMPTY_BYTES = new byte[0];
    static final int UOPF_PRS = 1;
    static final int UOPF_BND = 8;
    static final int UOPF_EXE = 32;
    static final int UOPF_FEX = 512;
    static final int UOPF_FCH = 64;
    static final int UOPF_CAN = 128;
    static final int UOPF_COM = 256;
    static final int UOPF_DSY = 8192;
    static final int UOPF_SIO = 1024;
    static final int UOPF_NPL = 32768;
    static final int UOPF_DFN = 16;
    int receiveState = 0;
    static final int IDLE_RECEIVE_STATE = 0;
    static final int ACTIVE_RECEIVE_STATE = 1;
    static final int READROW_RECEIVE_STATE = 2;
    static final int STREAM_RECEIVE_STATE = 3;
    int rowsProcessed;
    int number_of_define_positions;
    long options;
    int cursor;
    byte[] sqlStmt = new byte[0];
    final long[] al8i4 = new long[13];
    boolean plsql = false;
    Accessor[] definesAccessors;
    int definesLength;
    Accessor[] outBindAccessors;
    int number_of_bind_positions;
    InputStream[][] parameterStream;
    byte[][][] parameterDatum;
    OracleTypeADT[][] parameterOtype;
    short[] bindIndicators;
    byte[] bindBytes;
    char[] bindChars;
    int bindIndicatorSubRange;
    byte[] tmpBindsByteArray;
    DBConversion conversion;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    boolean sendBindsDefinition = false;
    OracleStatement oracleStatement;
    short dbCharSet;
    short NCharSet;
    T4CTTIrxd rxd;
    T4C8TTIrxh rxh;
    T4CTTIoac oac;
    T4CTTIdcb dcb;
    T4CTTIofetch ofetch;
    T4CTTIoexec oexec;
    byte type;
    boolean sendDefines = false;
    int rowsToFetch;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050624";

    T4C8Oall(T4CMAREngine t4CMAREngine, T4CConnection t4CConnection, T4CTTIoer t4CTTIoer) throws IOException, SQLException {
        super((byte)3, 0, (short)94);
        this.setMarshalingEngine(t4CMAREngine);
        this.rxh = new T4C8TTIrxh(this.meg);
        this.rxd = new T4CTTIrxd(this.meg);
        this.oer = t4CTTIoer;
        this.oac = new T4CTTIoac(this.meg);
        this.dcb = new T4CTTIdcb(this.meg);
        this.ofetch = new T4CTTIofetch(this.meg);
        this.oexec = new T4CTTIoexec(this.meg);
    }

    void continueReadRow(int n) throws SQLException, IOException {
        this.receiveState = 2;
        if (this.rxd.unmarshal(this.definesAccessors, n, this.definesLength)) {
            this.receiveState = 3;
            return;
        }
        this.receive();
    }

    int getCursorId() {
        return this.cursor;
    }

    int getNumRows() {
        int n = 0;
        if (this.receiveState == 3) {
            n = -2;
        } else {
            switch (this.type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n = this.rowsProcessed;
                    break;
                }
                case 0: {
                    n = this.definesAccessors != null && this.definesLength > 0 ? this.definesAccessors[0].lastRowProcessed : 0;
                    break;
                }
            }
        }
        return n;
    }

    T4CTTIoac[] init(boolean bl, boolean bl2, boolean bl3, boolean bl4, byte by, int n, byte[] byArray, int n2, Accessor[] accessorArray, int n3, Accessor[] accessorArray2, int n4, byte[] byArray2, char[] cArray, short[] sArray, int n5, DBConversion dBConversion, byte[] byArray3, InputStream[][] inputStreamArray, byte[][][] byArray4, OracleTypeADT[][] oracleTypeADTArray, OracleStatement oracleStatement, byte[] byArray5, char[] cArray2, short[] sArray2, T4CTTIoac[] t4CTTIoacArray) throws IOException, SQLException {
        if (byArray == null) {
            DatabaseError.check_error(431);
        }
        this.definesAccessors = accessorArray2;
        this.definesLength = n4;
        this.outBindAccessors = accessorArray;
        this.number_of_bind_positions = n3;
        this.type = by;
        this.cursor = n;
        this.sqlStmt = bl ? byArray : EMPTY_BYTES;
        this.rowsToFetch = n2;
        this.bindBytes = byArray2;
        this.bindChars = cArray;
        this.bindIndicators = sArray;
        this.bindIndicatorSubRange = n5;
        this.tmpBindsByteArray = byArray3;
        this.conversion = dBConversion;
        this.dbCharSet = dBConversion.getDbCharSet();
        this.NCharSet = dBConversion.getNCharSet();
        this.parameterStream = inputStreamArray;
        this.parameterDatum = byArray4;
        this.parameterOtype = oracleTypeADTArray;
        this.oracleStatement = oracleStatement;
        this.ibtBindBytes = byArray5;
        this.ibtBindChars = cArray2;
        this.ibtBindIndicators = sArray2;
        this.rowsProcessed = 0;
        this.options = 0L;
        this.plsql = this.type == 1 || this.type == 4;
        this.sendBindsDefinition = false;
        if (this.receiveState != 0) {
            this.receiveState = 0;
            DatabaseError.throwSqlException("OALL8 is in an inconsistent state.", "", 0);
        }
        this.rxh.init();
        this.rxd.init();
        this.oer.init();
        if (this.number_of_bind_positions > 0 && this.bindIndicators != null) {
            if (t4CTTIoacArray == null) {
                t4CTTIoacArray = new T4CTTIoac[this.number_of_bind_positions];
            }
            this.sendBindsDefinition = this.initBindsDefinition(t4CTTIoacArray);
        }
        this.options = this.setOptions(bl, bl2, bl3);
        this.al8i4[0] = (this.options & 1L) > 0L ? 1L : 0L;
        if (this.plsql || this.type == 3) {
            this.al8i4[1] = 1L;
        } else if (bl4) {
            this.al8i4[1] = bl3 && this.oracleStatement.connection.useFetchSizeWithLongColumn ? (long)this.rowsToFetch : 0L;
        } else if (this.type == 2) {
            int n6 = 0;
            if (this.bindIndicators != null) {
                n6 = this.bindIndicators[this.bindIndicatorSubRange + 2] & 0xFFFF;
            }
            this.al8i4[1] = n6 == 0 ? 1 : n6;
        } else {
            this.al8i4[1] = bl3 && !bl4 ? (long)this.rowsToFetch : 0L;
        }
        this.al8i4[7] = this.type == 0 ? 1L : 0L;
        return t4CTTIoacArray;
    }

    boolean initBindsDefinition(T4CTTIoac[] t4CTTIoacArray) throws SQLException, IOException {
        boolean bl = false;
        if (t4CTTIoacArray.length != this.number_of_bind_positions) {
            bl = true;
            t4CTTIoacArray = new T4CTTIoac[this.number_of_bind_positions];
        }
        short[] sArray = this.bindIndicators;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.number_of_bind_positions) {
            int n4;
            int n5 = this.bindIndicatorSubRange + 3 + 10 * n3;
            short s = sArray[n5 + 9];
            int n6 = sArray[n5] & 0xFFFF;
            if (n6 == 8 || n6 == 24) {
                n = this.plsql ? 32760 : Integer.MAX_VALUE;
            } else if (this.type != 998 && (n = sArray[n5 + 1] & 0xFFFF) == 0) {
                if (this.type == 1) {
                    n = 32766;
                } else if (this.type == 4) {
                    n4 = sArray[n5 + 2] & 0xFFFF;
                    n = n4 > 4001 ? n4 : 4001;
                } else {
                    n = sArray[n5 + 2] & 0xFFFF;
                    if (n6 == 996) {
                        n *= 2;
                    } else if (n > 1) {
                        --n;
                    }
                    n = s == 2 ? Math.min(n * this.conversion.m_nMaxCharSize, 4000) : (((T4CConnection)this.oracleStatement.connection).retainV9BehaviorForLong && n <= 4000 ? Math.min(n * this.conversion.m_sMaxCharSize, 4000) : (n *= this.conversion.m_sMaxCharSize));
                }
            }
            if (n6 == 9 || n6 == 996) {
                n6 = 1;
            }
            if (n6 == 109 || n6 == 111) {
                if (this.outBindAccessors != null && this.outBindAccessors[n3] != null) {
                    if (this.outBindAccessors[n3].t_otype != null) {
                        this.oac.init((OracleTypeADT)((TypeAccessor)this.outBindAccessors[n3]).t_otype, n6, n6 == 109 ? 11 : 4000);
                    }
                } else if (this.parameterOtype != null && this.parameterOtype[0] != null) {
                    this.oac.init(this.parameterOtype[0][n3], n6, n6 == 109 ? 11 : 4000);
                } else {
                    DatabaseError.throwSqlException("INTERNAL ERROR: Binding NAMED_TYPE but no type defined", null, -1);
                }
            } else if (n6 == 998) {
                if (this.outBindAccessors != null && this.outBindAccessors[n3] != null) {
                    this.oac.init((PlsqlIndexTableAccessor)this.outBindAccessors[n3]);
                } else if (this.ibtBindIndicators[6 + n2 * 8] != 0) {
                    n4 = this.ibtBindIndicators[6 + n2 * 8];
                    int n7 = this.ibtBindIndicators[6 + n2 * 8 + 2] << 16 & 0xFFFF000 | this.ibtBindIndicators[6 + n2 * 8 + 3];
                    n = this.ibtBindIndicators[6 + n2 * 8 + 1];
                    this.oac.initIbt((short)n4, n7, n);
                    ++n2;
                } else {
                    DatabaseError.throwSqlException("INTERNAL ERROR: Binding PLSQL index-by table but no type defined", null, -1);
                }
            } else {
                this.oac.init((short)n6, n, this.dbCharSet, this.NCharSet, s);
            }
            if (t4CTTIoacArray[n3] == null || !this.oac.isOldSufficient(t4CTTIoacArray[n3])) {
                T4CTTIoac t4CTTIoac;
                t4CTTIoacArray[n3] = t4CTTIoac = new T4CTTIoac(this.oac);
                bl = true;
            }
            ++n3;
        }
        return bl;
    }

    void marshalAll(T4CTTIoac[] t4CTTIoacArray) throws SQLException, IOException {
        if ((this.options & 0x40L) != 0L && (this.options & 0x20L) == 0L && (this.options & 1L) == 0L && (this.options & 8L) == 0L && !this.oracleStatement.needToSendOalToFetch) {
            this.ofetch.marshal(this.cursor, (int)this.al8i4[1]);
        } else if (this.meg.versionNumber >= 10000 && (this.options & 0x20L) != 0L && (this.options & 1L) == 0L && (this.options & 0x40L) == 0L && (this.options & 8L) == 0L) {
            int n = 0;
            if ((this.options & 0x100L) != 0L) {
                n = 1;
            }
            this.oexec.marshal(this.cursor, (int)this.al8i4[1], n);
            if (this.number_of_bind_positions > 0 && this.bindIndicators != null) {
                int[] nArray = new int[this.number_of_bind_positions];
                int n2 = 0;
                while (n2 < this.number_of_bind_positions) {
                    nArray[n2] = t4CTTIoacArray[n2].oacmxl;
                    ++n2;
                }
                this.marshalBinds(nArray);
            }
        } else {
            if (this.oracleStatement.needToSendOalToFetch) {
                this.oracleStatement.needToSendOalToFetch = false;
            }
            this.marshalPisdef();
            this.meg.marshalCHR(this.sqlStmt);
            this.meg.marshalUB4Array(this.al8i4);
            int[] nArray = new int[this.number_of_bind_positions];
            int n = 0;
            while (n < this.number_of_bind_positions) {
                nArray[n] = t4CTTIoacArray[n].oacmxl;
                ++n;
            }
            if ((this.options & 8L) != 0L && this.number_of_bind_positions > 0 && this.bindIndicators != null && this.sendBindsDefinition) {
                this.marshalBindsTypes(t4CTTIoacArray);
            }
            if ((this.options & 0x20L) != 0L && this.number_of_bind_positions > 0 && this.bindIndicators != null) {
                this.marshalBinds(nArray);
            }
        }
    }

    void marshalBinds(int[] nArray) throws SQLException, IOException {
        int n = this.bindIndicators[this.bindIndicatorSubRange + 2] & 0xFFFF;
        int n2 = 0;
        while (n2 < n) {
            this.rxd.marshal(this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.tmpBindsByteArray, this.conversion, this.parameterStream, this.parameterDatum, this.parameterOtype, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, null, n2, nArray, this.plsql);
            ++n2;
        }
    }

    void marshalBindsTypes(T4CTTIoac[] t4CTTIoacArray) throws SQLException, IOException {
        if (t4CTTIoacArray == null) {
            return;
        }
        int n = 0;
        while (n < t4CTTIoacArray.length) {
            t4CTTIoacArray[n].marshal();
            ++n;
        }
    }

    void marshalPisdef() throws IOException, SQLException {
        int n;
        super.marshalFunHeader();
        this.meg.marshalUB4(this.options);
        this.meg.marshalSWORD(this.cursor);
        if (this.sqlStmt.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSWORD(this.sqlStmt.length);
        if (this.al8i4.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSWORD(this.al8i4.length);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalUB4(0L);
        if (this.type != 1 && this.type != 4) {
            this.meg.marshalUB4(Integer.MAX_VALUE);
        } else {
            this.meg.marshalUB4(32760L);
        }
        if ((this.options & 8L) != 0L && this.number_of_bind_positions > 0 && this.sendBindsDefinition) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.number_of_bind_positions);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        int n2 = n = this.definesAccessors == null ? 0 : this.definesLength;
        if (this.meg.versionNumber >= 9000) {
            if (n > 0 && this.sendDefines) {
                this.meg.marshalPTR();
                this.meg.marshalSWORD(n);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
        }
    }

    void receive() throws SQLException, IOException {
        if (this.receiveState != 0 && this.receiveState != 2) {
            DatabaseError.throwSqlException("OALL8 is in an inconsistent state.", "", 0);
        }
        this.receiveState = 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.rowsProcessed = 0;
        this.rxd.setNumberOfColumns(this.definesLength);
        block13: while (true) {
            try {
                while (true) {
                    byte by = this.meg.unmarshalSB1();
                    switch (by) {
                        case 21: {
                            int n = this.meg.unmarshalUB2();
                            this.rxd.unmarshalBVC(n);
                            break;
                        }
                        case 11: {
                            T4CTTIiov t4CTTIiov = new T4CTTIiov(this.meg, this.rxh, this.rxd);
                            t4CTTIiov.init();
                            t4CTTIiov.unmarshalV10();
                            if (!t4CTTIiov.isIOVectorEmpty()) {
                                byte[] byArray = t4CTTIiov.getIOVector();
                                this.outBindAccessors = t4CTTIiov.processRXD(this.outBindAccessors, this.number_of_bind_positions, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.conversion, this.tmpBindsByteArray, byArray, this.parameterStream, this.parameterDatum, this.parameterOtype, this.oracleStatement, null, null, null);
                            }
                            bl3 = true;
                            break;
                        }
                        case 6: {
                            this.rxh.init();
                            this.rxh.unmarshalV10(this.rxd);
                            if (this.rxh.uacBufLength > 0) {
                                DatabaseError.check_error(405);
                            }
                            bl2 = true;
                            break;
                        }
                        case 7: {
                            if (this.receiveState != 1) {
                                DatabaseError.throwSqlException("OALL8 is in an inconsistent state.", "", 0);
                            }
                            this.receiveState = 2;
                            if (bl3) {
                                if (this.rxd.unmarshal(this.outBindAccessors, this.number_of_bind_positions)) {
                                    this.receiveState = 3;
                                    return;
                                }
                            } else if (this.rxd.unmarshal(this.definesAccessors, this.definesLength)) {
                                this.receiveState = 3;
                                return;
                            }
                            this.receiveState = 1;
                            break;
                        }
                        case 8: {
                            if (bl) {
                                DatabaseError.check_error(401);
                            }
                            int n = (int)this.meg.unmarshalUB4();
                            int[] nArray = new int[n];
                            int n2 = 0;
                            while (n2 < n) {
                                nArray[n2] = (int)this.meg.unmarshalUB4();
                                ++n2;
                            }
                            this.cursor = nArray[2];
                            this.meg.unmarshalUB2();
                            n2 = this.meg.unmarshalUB2();
                            if (n2 > 0) {
                                int n3 = 0;
                                while (n3 < n2) {
                                    int n4 = (int)this.meg.unmarshalUB4();
                                    this.meg.unmarshalDALC();
                                    int n5 = this.meg.unmarshalUB2();
                                    ++n3;
                                }
                            }
                            bl = true;
                            break;
                        }
                        case 16: {
                            this.dcb.init(this.oracleStatement, 0);
                            this.definesAccessors = this.dcb.receive(this.definesAccessors);
                            this.definesLength = this.number_of_define_positions = this.dcb.numuds;
                            this.rxd.setNumberOfColumns(this.number_of_define_positions);
                            break;
                        }
                        case 4: {
                            this.oer.init();
                            this.cursor = this.oer.unmarshal();
                            this.rowsProcessed = this.oer.getCurRowNumber();
                            if (this.type == 0 && (this.type != 0 || this.oer.retCode == 1403)) break block13;
                            try {
                                this.oer.processError();
                                break block13;
                            }
                            catch (SQLException sQLException) {
                                this.receiveState = 0;
                                throw sQLException;
                            }
                        }
                        default: {
                            DatabaseError.check_error(401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException breakNetException) {
                continue;
            }
            break;
        }
        if (this.receiveState != 1) {
            DatabaseError.throwSqlException("OALL8 is in an inconsistent state.", "", 0);
        }
        this.receiveState = 0;
    }

    long setOptions(boolean bl, boolean bl2, boolean bl3) throws SQLException {
        long l = 0L;
        if (bl && !bl2 && !bl3) {
            l |= 1L;
        } else if (bl && bl2 && !bl3) {
            l = 32801L;
        } else if (bl2 && bl3) {
            if (bl) {
                l |= 1L;
            }
            switch (this.type) {
                case 0: {
                    l |= 0x8060L;
                    break;
                }
                case 1: 
                case 4: {
                    if (this.number_of_bind_positions > 0) {
                        l |= 0x428L | (long)(this.oracleStatement.connection.auto_commit ? 256 : 0);
                        break;
                    }
                    l |= 0x20L | (long)(this.oracleStatement.connection.auto_commit ? 256 : 0);
                    break;
                }
                case 2: 
                case 3: {
                    l |= 0x8020L | (long)(this.oracleStatement.connection.auto_commit ? 256 : 0);
                    break;
                }
                default: {
                    DatabaseError.check_error(432);
                    break;
                }
            }
        } else if (!bl && !bl2 && bl3) {
            l = 32832L;
        } else {
            DatabaseError.check_error(432);
        }
        if (this.type != 1 && this.type != 4) {
            if ((bl || bl2 || !bl3) && this.number_of_bind_positions > 0 && this.sendBindsDefinition) {
                l |= 8L;
            }
            if (this.sendDefines) {
                l |= 0x10L;
            }
        }
        return l &= 0xFFFFFFFFFFFFFFFFL;
    }
}

