/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ClobDBAccess;
import oracle.sql.DatumWithConnection;

public class CLOB
extends DatumWithConnection
implements Clob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    ClobDBAccess m_dbaccess;
    private int m_dbChunkSize;
    private short csform;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050624";

    protected CLOB() {
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (byArray != null) {
            this.csform = (byArray[5] & 0xC0) == 64 ? (short)2 : (short)1;
        }
        DatumWithConnection.assertNotNull(oracleConnection);
        this.setPhysicalConnectionOf(oracleConnection);
        this.m_dbaccess = ((OracleConnection)oracleConnection).createClobDBAccess();
        this.m_dbChunkSize = -1;
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, short s) throws SQLException {
        this(oracleConnection, byArray);
        this.csform = s;
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public Reader characterStreamValue() throws SQLException {
        return this.getCharacterStream();
    }

    public void close() throws SQLException {
        this.getDBAccess().close(this);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n) throws SQLException {
        return CLOB.createTemporary(connection, bl, n, (short)1);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n, short s) throws SQLException {
        int n2 = n;
        if (n == 1) {
            n2 = 10;
        }
        if (n == 2) {
            n2 = 12;
        }
        if (connection == null || n2 != 10 && n2 != 12) {
            DatabaseError.throwSqlException(68);
        }
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        CLOB cLOB = CLOB.getDBAccess(oracleConnection).createTemporaryClob(oracleConnection, bl, n2, s);
        cLOB.csform = s;
        return cLOB;
    }

    public static CLOB empty_lob() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        CLOB cLOB = new CLOB();
        cLOB.setShareBytes(byArray);
        return cLOB;
    }

    public void freeTemporary() throws SQLException {
        this.getDBAccess().freeTemporary(this);
    }

    public static void freeTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return;
        }
        cLOB.freeTemporary();
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.setAsciiStream(0L);
    }

    public OutputStream getAsciiOutputStream(long l) throws SQLException {
        return this.setAsciiStream(l);
    }

    public InputStream getAsciiStream() throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public InputStream getAsciiStream(long l) throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l);
    }

    public int getBufferSize() throws SQLException {
        int n = this.getChunkSize();
        int n2 = 0;
        n2 = n >= 32768 || n <= 0 ? 32768 : 32768 / n * n;
        return n2;
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return this.setCharacterStream(0L);
    }

    public Writer getCharacterOutputStream(long l) throws SQLException {
        return this.setCharacterStream(l);
    }

    public Reader getCharacterStream() throws SQLException {
        return this.getDBAccess().newReader(this, this.getBufferSize(), 0L);
    }

    public Reader getCharacterStream(long l) throws SQLException {
        return this.getDBAccess().newReader(this, this.getBufferSize(), l);
    }

    public int getChars(long l, int n, char[] cArray) throws SQLException {
        return this.getDBAccess().getChars(this, l, n, cArray);
    }

    public int getChunkSize() throws SQLException {
        if (this.m_dbChunkSize <= 0) {
            this.m_dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.m_dbChunkSize;
    }

    public ClobDBAccess getDBAccess() throws SQLException {
        if (this.m_dbaccess == null) {
            if (this.isEmptyLob()) {
                DatabaseError.throwSqlException(98);
            }
            this.m_dbaccess = this.getInternalConnection().createClobDBAccess();
        }
        if (this.getPhysicalConnection().isClosed()) {
            DatabaseError.throwSqlException(8);
        }
        return this.m_dbaccess;
    }

    public static ClobDBAccess getDBAccess(Connection connection) throws SQLException {
        return ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().createClobDBAccess();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public String getSubString(long l, int n) throws SQLException {
        char[] cArray;
        int n2;
        if (n < 0 || l < 1L) {
            DatabaseError.check_error(68, "getSubString");
        }
        String string = null;
        string = n == 0 ? new String() : ((n2 = this.getChars(l, n, cArray = new char[n])) > 0 ? new String(cArray, 0, n2) : new String());
        return string;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public boolean isEmptyLob() throws SQLException {
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    public boolean isNCLOB() {
        boolean bl = this.csform == 2;
        return bl;
    }

    public boolean isOpen() throws SQLException {
        return this.getDBAccess().isOpen(this);
    }

    public boolean isTemporary() throws SQLException {
        return this.getDBAccess().isTemporary(this);
    }

    public static boolean isTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return false;
        }
        return cLOB.isTemporary();
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public Object makeJdbcArray(int n) {
        return new CLOB[n];
    }

    public void open(int n) throws SQLException {
        this.getDBAccess().open(this, n);
    }

    public long position(String string, long l) throws SQLException {
        return this.getDBAccess().position(this, string, l);
    }

    public long position(Clob clob, long l) throws SQLException {
        return this.getDBAccess().position(this, (CLOB)clob, l);
    }

    public int putChars(long l, char[] cArray) throws SQLException {
        int n = this.getDBAccess().putChars(this, l, cArray, 0, cArray != null ? cArray.length : 0);
        return n;
    }

    public int putChars(long l, char[] cArray, int n) throws SQLException {
        return this.getDBAccess().putChars(this, l, cArray, 0, n);
    }

    public int putChars(long l, char[] cArray, int n, int n2) throws SQLException {
        return this.getDBAccess().putChars(this, l, cArray, n, n2);
    }

    public int putString(long l, String string) throws SQLException {
        return this.setString(l, string);
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        return this.getDBAccess().newWriter(this, this.getBufferSize(), l);
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public int setString(long l, String string) throws SQLException {
        if (l < 1L) {
            DatabaseError.check_error(68, "setString()");
        }
        int n = 0;
        if (string != null && string.length() != 0) {
            n = this.putChars(l, string.toCharArray());
        }
        return n;
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (l < 1L) {
            DatabaseError.check_error(68, "setString()");
        }
        if (n < 0) {
            DatabaseError.check_error(68, "setString()");
        }
        if (n + n2 > string.length()) {
            DatabaseError.check_error(68, "setString()");
        }
        int n3 = 0;
        if (string != null && string.length() != 0) {
            n3 = this.putChars(l, string.toCharArray(), n, n2);
        }
        return n3;
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public void trim(long l) throws SQLException {
        this.truncate(l);
    }

    public void truncate(long l) throws SQLException {
        if (l < 0L) {
            DatabaseError.throwSqlException(68);
        }
        this.getDBAccess().trim(this, l);
    }
}

