/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.savedrequest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.util.PortResolver;
import org.acegisecurity.util.UrlUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class SavedRequest
implements Serializable {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$savedrequest$SavedRequest == null ? (class$org$acegisecurity$ui$savedrequest$SavedRequest = SavedRequest.class$("org.acegisecurity.ui.savedrequest.SavedRequest")) : class$org$acegisecurity$ui$savedrequest$SavedRequest));
    private ArrayList cookies = new ArrayList();
    private ArrayList locales = new ArrayList();
    private HashMap headers = new HashMap();
    private HashMap parameters = new HashMap();
    private String contextPath;
    private String method;
    private String pathInfo;
    private String queryString;
    private String requestURI;
    private String requestURL;
    private String scheme;
    private String serverName;
    private String servletPath;
    private int serverPort;
    static /* synthetic */ Class class$org$acegisecurity$ui$savedrequest$SavedRequest;

    public SavedRequest(HttpServletRequest request, PortResolver portResolver) {
        Assert.notNull((Object)request, (String)"Request required");
        Assert.notNull((Object)portResolver, (String)"PortResolver required");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                this.addCookie(cookies[i]);
            }
        }
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                this.addHeader(name, value);
            }
        }
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            this.addLocale(locale);
        }
        Map parameters = request.getParameterMap();
        Iterator paramNames = parameters.keySet().iterator();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            String[] paramValues = (String[])parameters.get(paramName);
            this.addParameter(paramName, paramValues);
        }
        this.method = request.getMethod();
        this.pathInfo = request.getPathInfo();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.serverPort = portResolver.getServerPort((ServletRequest)request);
        this.requestURL = request.getRequestURL().toString();
        this.scheme = request.getScheme();
        this.serverName = request.getServerName();
        this.contextPath = request.getContextPath();
        this.servletPath = request.getServletPath();
    }

    private void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    private void addHeader(String name, String value) {
        ArrayList<String> values = (ArrayList<String>)this.headers.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    private void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    private void addParameter(String name, String[] values) {
        this.parameters.put(name, values);
    }

    public boolean doesRequestMatch(HttpServletRequest request, PortResolver portResolver) {
        Assert.notNull((Object)request, (String)"Request required");
        Assert.notNull((Object)portResolver, (String)"PortResolver required");
        if (!this.propertyEquals("pathInfo", this.pathInfo, request.getPathInfo())) {
            return false;
        }
        if (!this.propertyEquals("queryString", this.queryString, request.getQueryString())) {
            return false;
        }
        if (!this.propertyEquals("requestURI", this.requestURI, request.getRequestURI())) {
            return false;
        }
        if (!this.propertyEquals("serverPort", new Integer(this.serverPort), new Integer(portResolver.getServerPort((ServletRequest)request)))) {
            return false;
        }
        if (!this.propertyEquals("requestURL", this.requestURL, request.getRequestURL().toString())) {
            return false;
        }
        if (!this.propertyEquals("scheme", this.scheme, request.getScheme())) {
            return false;
        }
        if (!this.propertyEquals("serverName", this.serverName, request.getServerName())) {
            return false;
        }
        if (!this.propertyEquals("contextPath", this.contextPath, request.getContextPath())) {
            return false;
        }
        return this.propertyEquals("servletPath", this.servletPath, request.getServletPath());
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public List getCookies() {
        return this.cookies;
    }

    public String getFullRequestUrl() {
        return UrlUtils.getFullRequestUrl(this);
    }

    public Iterator getHeaderNames() {
        return this.headers.keySet().iterator();
    }

    public Iterator getHeaderValues(String name) {
        ArrayList values = (ArrayList)this.headers.get(name);
        if (values == null) {
            return new ArrayList().iterator();
        }
        return values.iterator();
    }

    public Iterator getLocales() {
        return this.locales.iterator();
    }

    public String getMethod() {
        return this.method;
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Iterator getParameterNames() {
        return this.parameters.keySet().iterator();
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public String getRequestUrl() {
        return UrlUtils.getRequestUrl(this);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    private boolean propertyEquals(String log, Object arg1, Object arg2) {
        if (arg1 == null && arg2 == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(log + ": both null (property equals)"));
            }
            return true;
        }
        if (arg1 == null && arg2 != null || arg1 != null && arg2 == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(log + ": arg1=" + arg1 + "; arg2=" + arg2 + " (property not equals)"));
            }
            return false;
        }
        if (arg1.equals(arg2)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(log + ": arg1=" + arg1 + "; arg2=" + arg2 + " (property equals)"));
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(log + ": arg1=" + arg1 + "; arg2=" + arg2 + " (property not equals)"));
        }
        return false;
    }

    public String toString() {
        return "SavedRequest[" + this.getFullRequestUrl() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

