/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.ui.global.tags;

import com.posdata.glue.dao.vo.PosPageSet;
import com.posdata.glue.dao.vo.PosRow;
import com.posdata.glue.dao.vo.PosRowSet;
import com.posdata.glue.ui.global.tags.ResourceHandler;
import com.posdata.glue.ui.tags.ShowTag;
import com.posdata.glue.ui.tags.util.PosTagUtil;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.jsp.JspWriter;

public class ShowTable
extends ShowTag {
    private String tableName;
    private String infoName;
    private String[] columnNames;
    private String[] columnWidths;
    private String headerValues;
    private String[] displayTypes;
    private String[] displayFormats;
    private String[] attributes;
    private String[] tdEvents;
    private String[] selectInfoNames;
    private String defaultRowCnt;
    private int[] tempDisplayTypes;
    private String[] headerClasses;
    private String[] trClasses;
    private String[] tdClasses;
    private String height;
    private String[] attrClasses;
    private int infoSize = 0;
    private PosRowSet infoList = null;
    private PosRow[] infoArrayList = null;
    private int trCount = 0;
    private JspWriter htmlBuffer = null;
    private String[] headerEvents = null;
    private int curPage = 1;
    private int curNo = 0;
    private String curPageName = "curPage";
    private String resource = null;
    private Locale locale = null;

    protected void buildHTML(JspWriter out) throws IOException {
        this.htmlBuffer = out;
        this.setCurPage();
        this.htmlBuffer.print("  <table id=\"" + this.getTableName() + "\"");
        this.htmlBuffer.print(" width=\"" + this.sumWidth(this.columnWidths) + "\"");
        this.htmlBuffer.print(" border=1 cellspacing=\"0\" cellpadding=\"0\" bordercolorlight=\"#666666\" bordercolordark=\"#FFFFFF\">");
        this.htmlBuffer.print("\n\r");
        this.buildHeader();
        this.htmlBuffer.flush();
        this.makeTr();
        this.htmlBuffer.print("  </table>");
        this.htmlBuffer.print("\n\r");
        this.htmlBuffer.flush();
    }

    private void buildHeader() throws IOException {
        if (this.getHeaderValues() != null && !this.getHeaderValues().equals("")) {
            String[] trHeaders = PosTagUtil.parseParameters((String)this.getHeaderValues(), (String)";");
            String[] tdHeadersLen = PosTagUtil.parseParameters((String)trHeaders[0], (String)"|");
            int[] rowspanYN = new int[tdHeadersLen.length];
            for (int i = 0; i < trHeaders.length; ++i) {
                this.htmlBuffer.print("    ");
                this.htmlBuffer.print("<tr");
                if (this.getHeaderClasses() != null && !this.getHeaderClasses().equals("")) {
                    this.htmlBuffer.print(" class=\"" + this.getHeaderClasses()[i] + "\"");
                }
                if (this.getHeight() != null && !this.getHeight().equals("")) {
                    this.htmlBuffer.print(" height=\"" + this.getHeight() + "\"");
                }
                this.htmlBuffer.print(">");
                this.htmlBuffer.print("\n\r");
                String[] tdHeaders = ResourceHandler.getResourceFromParameters(trHeaders[i], "|", this.resource, this.locale);
                int tdCount = 0;
                while (tdCount < tdHeaders.length) {
                    if (rowspanYN[tdCount] < 2) {
                        int rowspan;
                        this.htmlBuffer.print("      ");
                        this.htmlBuffer.print("<td align=\"absmiddle\" ");
                        int colspan = this.countColspan(tdHeaders, tdCount);
                        rowspanYN[tdCount] = rowspan = this.countRowspan(trHeaders, i, tdCount);
                        if (rowspan > 1) {
                            this.htmlBuffer.print(" width=\"" + this.columnWidths[tdCount] + "\"");
                            this.htmlBuffer.print(" rowspan=\"" + rowspan + "\"");
                            ++tdCount;
                        } else if (colspan > 1) {
                            int width = 0;
                            for (int j = 0; j < colspan; ++j) {
                                width += Integer.parseInt(this.columnWidths[tdCount]);
                                ++tdCount;
                            }
                            this.htmlBuffer.print(" width=\"" + String.valueOf(width) + "\"");
                            this.htmlBuffer.print(" colspan=\"" + colspan + "\"");
                        } else {
                            this.htmlBuffer.print(" width=\"" + this.columnWidths[tdCount] + "\"");
                            ++tdCount;
                        }
                        if (this.headerEvents != null && this.headerEvents[i] != null && !"".equals(this.headerEvents[i])) {
                            this.htmlBuffer.print(" " + this.headerEvents[i]);
                        }
                        this.htmlBuffer.print(">");
                        this.htmlBuffer.print(tdHeaders[tdCount - 1]);
                        this.htmlBuffer.print("</td>");
                        this.htmlBuffer.print("\n\r");
                        continue;
                    }
                    rowspanYN[tdCount] = rowspanYN[tdCount] - 1;
                    ++tdCount;
                }
                this.htmlBuffer.print("    ");
                this.htmlBuffer.print("</tr>");
                this.htmlBuffer.print("\n\r");
            }
        }
    }

    private void makeTr() throws IOException {
        int trCount = 0;
        if (this.isPageSet()) {
            if (this.defaultRowCnt != null) {
                trCount = Integer.parseInt(this.defaultRowCnt);
            }
        } else if (this.infoSize > 0) {
            trCount = this.infoSize;
        } else if (this.defaultRowCnt != null) {
            trCount = Integer.parseInt(this.defaultRowCnt);
        }
        for (int i = 0; i < trCount; ++i) {
            this.htmlBuffer.print("    ");
            this.htmlBuffer.print("<tr");
            if (this.getTrClasses() != null && this.getTrClasses().length > 0) {
                int num = i % this.getTrClasses().length;
                this.htmlBuffer.print(" class=\"" + this.getTrClasses()[num] + "\"");
            }
            if (this.getHeight() != null && !this.getHeight().equals("")) {
                this.htmlBuffer.print(" height=\"" + this.getHeight() + "\"");
            }
            this.htmlBuffer.print(">");
            this.htmlBuffer.print("\n\r");
            this.makeTds(i);
            this.htmlBuffer.print("    ");
            this.htmlBuffer.print("</tr>");
            this.htmlBuffer.print("\n\r");
            ++this.trCount;
            this.htmlBuffer.flush();
        }
    }

    private void makeTds(int index) throws IOException {
        this.parseTdDisplayType();
        if (index == 0) {
            boolean isDateBox = false;
            for (int i = 0; i < this.columnWidths.length; ++i) {
                if (this.tempDisplayTypes[i] != 7) continue;
                isDateBox = true;
            }
            if (isDateBox) {
                this.htmlBuffer.print("<script language=\"JavaScript\" src=\"/js/showCalendar.js\"></script>");
            }
        }
        for (int i = 0; i < this.columnWidths.length; ++i) {
            this.htmlBuffer.print("      ");
            if (Integer.parseInt(this.columnWidths[i]) == 0 && this.tempDisplayTypes[i] == 6) {
                this.makeTdValue(i);
            } else {
                this.htmlBuffer.print("<td");
                if (this.columnNames != null && !"".equals(this.columnNames[i])) {
                    this.htmlBuffer.print(" id=" + this.columnNames[i]);
                }
                this.htmlBuffer.print(" index=" + index);
                this.htmlBuffer.print(" width=" + this.columnWidths[i]);
                if (this.tdClasses != null && this.tdClasses[i] != null && !"".equals(this.tdClasses[i])) {
                    if (this.tdClasses[i].equals("left") || this.tdClasses[i].equals("right")) {
                        this.htmlBuffer.print(" align=\"" + this.tdClasses[i] + "\"");
                    } else {
                        this.htmlBuffer.print(" class=\"" + this.tdClasses[i] + "\"");
                    }
                }
                if (this.tdEvents != null && this.tdEvents[i] != null && !"".equals(this.tdEvents[i]) && this.tempDisplayTypes[i] != 9 && this.tempDisplayTypes[i] != 8) {
                    this.htmlBuffer.print(" " + this.tdEvents[i]);
                }
                this.htmlBuffer.print(">");
                this.makeTdValue(i);
                this.htmlBuffer.print("</td>");
            }
            this.htmlBuffer.print("\n\r");
        }
    }

    private void makeTdValue(int index) throws IOException {
        switch (this.tempDisplayTypes[index]) {
            case 0: {
                this.htmlBuffer.print(this.buildTextTd(this.trCount, index, this.attributes[index]));
                break;
            }
            case 1: {
                this.htmlBuffer.print(this.buildCheckNoTd(this.trCount, this.columnNames[index]));
                break;
            }
            case 2: {
                this.htmlBuffer.print(this.buildRadioTd(this.trCount, this.columnNames[index]));
                break;
            }
            case 3: {
                this.htmlBuffer.print(this.buildRTextBoxTd(index, this.attributes[index]));
                break;
            }
            case 4: {
                this.htmlBuffer.print(this.buildLTextBoxTd(index, this.attributes[index]));
                break;
            }
            case 5: {
                this.htmlBuffer.print(this.buildSelectTd(index, this.columnNames[index]));
                break;
            }
            case 6: {
                this.htmlBuffer.print(this.buildHiddenTd(this.trCount, index, this.columnNames[index], this.attributes[index]));
                break;
            }
            case 7: {
                this.htmlBuffer.print(this.buildDateBoxTd(this.trCount, index, this.attributes[index]));
                break;
            }
            case 8: {
                this.htmlBuffer.print(this.buildTextBoxButTd(index, this.trCount, this.attributes[index]));
                break;
            }
            case 9: {
                this.htmlBuffer.print(this.buildLinkTd(index, this.trCount, this.attributes[index]));
                break;
            }
            case 11: {
                this.htmlBuffer.print(this.buildNoTd(this.trCount));
            }
        }
    }

    private String getValue(int trCount, int index, String key) {
        String value = "";
        if (!"".equals(key) && !"null".equals(key.toLowerCase())) {
            if (trCount < this.infoSize) {
                Map map = this.infoArrayList[trCount].getAttributes();
                if (map.get(key) != null) {
                    if (!"null".equals(map.get(key).toString().toLowerCase())) {
                        if (this.displayFormats != null && !this.displayFormats[index].equals("")) {
                            if (this.displayFormats[index].indexOf("#") != -1) {
                                try {
                                    DecimalFormat df = new DecimalFormat(this.displayFormats[index]);
                                    double dbvalue = Double.parseDouble(map.get(key).toString());
                                    value = df.format(dbvalue);
                                }
                                catch (NumberFormatException e) {
                                    value = map.get(key).toString();
                                }
                            } else if (this.displayFormats[index].toUpperCase().indexOf("YY") != -1 || this.displayFormats[index].toUpperCase().indexOf("MM") != -1 || this.displayFormats[index].toUpperCase().indexOf("DD") != -1 || this.displayFormats[index].toUpperCase().indexOf("HH") != -1 || this.displayFormats[index].indexOf("mm") != -1 || this.displayFormats[index].toUpperCase().indexOf("SS") != -1) {
                                try {
                                    String outDate;
                                    Date oraDate = null;
                                    oraDate = map.get(key) instanceof Date ? (Date)map.get(key) : new Date(Long.parseLong(map.get(key).toString()));
                                    SimpleDateFormat df = new SimpleDateFormat(this.displayFormats[index]);
                                    value = outDate = df.format(oraDate).toString();
                                }
                                catch (Exception e) {
                                    value = map.get(key).toString();
                                }
                            } else {
                                value = map.get(key).toString();
                            }
                        } else {
                            value = map.get(key).toString();
                        }
                    } else {
                        value = "";
                    }
                } else {
                    value = "";
                }
            } else {
                value = "";
            }
        } else {
            value = "";
        }
        return value;
    }

    private String buildTextTd(int trCount, int index, String key) {
        String value = this.getValue(trCount, index, key);
        if ("".equals(value)) {
            value = "&nbsp;";
        }
        return value;
    }

    private String buildNoTd(int trCount) {
        return String.valueOf(this.curNo + trCount + 1);
    }

    private String buildRTextBoxTd(int index, String key) {
        return this.buildTextBoxTd(index, key, "right");
    }

    private String buildLTextBoxTd(int index, String key) {
        return this.buildTextBoxTd(index, key, "left");
    }

    private String buildRadioTd(int trCount, String key) {
        return this.buildTextBox("radio", false, 0, 0, "", "", "", "", key, String.valueOf(trCount), "");
    }

    private String buildTextBoxTd(int index, String key, String align) {
        String classes = "";
        if (!(this.getAttrClasses() == null || "".equals(this.getAttrClasses()[index]) || this.getAttrClasses()[index].equals("left") && this.getAttrClasses()[index].equals("right"))) {
            classes = this.getAttrClasses()[index];
        }
        int textHeight = 0;
        if (this.getHeight() != null && !this.getHeight().equals("")) {
            textHeight = Integer.parseInt(this.getHeight()) - 2;
        }
        return this.buildTextBox("text", true, Integer.parseInt(this.getColumnWidths()[index]) - 3, textHeight, align, "", "", classes, key, this.getValue(this.trCount, index, key), "");
    }

    private String buildHiddenTd(int trCount, int index, String keyName, String key) {
        String tdValue = this.getValue(trCount, index, key);
        if ("&nbsp;".equals(tdValue)) {
            tdValue = "";
        }
        return this.buildTextBox("hidden", false, 0, 0, "", "", "", "", keyName, tdValue, "");
    }

    private String buildDateBoxTd(int trCount, int index, String key) {
        int columnWidth = Integer.parseInt(this.getColumnWidths()[index]) - 25;
        if (columnWidth < 0) {
            columnWidth = 20;
        }
        String classes = "";
        if (!(this.getAttrClasses() == null || "".equals(this.getAttrClasses()[index]) || this.getAttrClasses()[index].equals("left") && this.getAttrClasses()[index].equals("right"))) {
            classes = this.getAttrClasses()[index];
        }
        int textHeight = 0;
        if (this.getHeight() != null && !this.getHeight().equals("")) {
            textHeight = Integer.parseInt(this.getHeight()) - 2;
        }
        String tdValue = this.buildTextBox("text", true, columnWidth, textHeight, "", "", "", classes, key, this.getValue(trCount, index, key), "");
        String strDisplayFormats = "";
        if (this.displayFormats != null && this.displayFormats[index].equals("")) {
            strDisplayFormats = this.displayFormats[index];
        }
        tdValue = String.valueOf(tdValue) + "&nbsp;" + this.buildImg("/img/m000010img.gif", "cursor:hand", 0, "onClick=\"javascript:jspCalendar(this.parentElement.index," + key + ",'" + strDisplayFormats + "','false')\"") + "&nbsp;";
        return tdValue;
    }

    private String buildImg(String src, String style, int border, String event) {
        StringBuffer imgValue = new StringBuffer(1024);
        imgValue.append("<img src=\"" + src + "\"");
        if (!"".equals(style)) {
            imgValue.append(" style=\"" + style + "\"");
        }
        if (border > 0) {
            imgValue.append(" border=\"" + border + "\"");
        }
        if (!"".equals(event)) {
            imgValue.append(" " + event);
        }
        imgValue.append(">");
        return imgValue.toString();
    }

    private String buildTextBoxButTd(int index, int trCount, String key) {
        int columnWidth = Integer.parseInt(this.getColumnWidths()[index]) - 20;
        if (columnWidth < 0) {
            columnWidth = 20;
        }
        String classes = "";
        if (!(this.getAttrClasses() == null || "".equals(this.getAttrClasses()[index]) || this.getAttrClasses()[index].equals("left") && this.getAttrClasses()[index].equals("right"))) {
            classes = this.getAttrClasses()[index];
        }
        int textHeight = 0;
        if (this.getHeight() != null && !this.getHeight().equals("")) {
            textHeight = Integer.parseInt(this.getHeight()) - 2;
        }
        String tdValue = this.buildTextBox("text", true, columnWidth, textHeight, "", "", "", classes, key, this.getValue(trCount, index, key), "");
        tdValue = String.valueOf(tdValue) + this.buildImgButtonTd(index, trCount, key);
        return tdValue;
    }

    private String buildImgButtonTd(int index, int trCount, String key) {
        return this.buildTextBox("image", false, 0, 0, "", "absmiddle", "/img/m000013img.gif", "", key, "", this.tdEvents[index]);
    }

    private String buildCheckNoTd(int trCount, String key) {
        return this.buildTextBox("checkbox", false, 0, 0, "", "", "", "", key, String.valueOf(trCount), "");
    }

    private String buildTextBox(String type, boolean styleYN, int width, int height, String textAlign, String align, String src, String classes, String name, String value, String event) {
        StringBuffer tdValue = new StringBuffer(1024);
        tdValue.append("<input type=\"" + type + "\"");
        if (styleYN) {
            tdValue.append(" style=\"");
            if (width > 0) {
                tdValue.append("width:" + width + ";");
            }
            if (height > 0) {
                tdValue.append("height:" + height + ";");
            }
            if (!"".equals(textAlign)) {
                tdValue.append("text-align:" + textAlign + ";");
            }
            tdValue.append("\"");
        }
        if (!"".equals(align)) {
            tdValue.append(" align=\"" + align + "\"");
        }
        if (!"".equals(src)) {
            tdValue.append(" src=\"" + src + "\"");
        }
        if (!"".equals(classes)) {
            tdValue.append(" class=\"" + classes + "\"");
        }
        tdValue.append(" name=\"" + name + "\"");
        tdValue.append(" value=\"" + value + "\"");
        if (!"".equals(event)) {
            tdValue.append(" " + event);
        }
        tdValue.append(">");
        return tdValue.toString();
    }

    private String buildLink(String linkEvent, String value) {
        if (value == null) {
            value = "&nbsp;";
        } else if ("".equals(value)) {
            value = "&nbsp;";
        }
        String tdValue = "<a href=\"" + linkEvent + "\">" + value + "</a>";
        return tdValue;
    }

    private String buildLinkTd(int index, int trCount, String key) {
        String tdValue = this.buildLink(this.tdEvents[index], this.getValue(trCount, index, key));
        return tdValue;
    }

    private String buildSelectTd(int index, String key) {
        List selectInfoList = null;
        if (this.info.getInfoObject(this.getSelectInfoNames()[index]) != null) {
            selectInfoList = (List)this.info.getInfoObject(this.getSelectInfoNames()[index]);
        }
        int textHeight = 0;
        if (this.getHeight() != null && !this.getHeight().equals("")) {
            textHeight = Integer.parseInt(this.getHeight()) - 2;
        }
        String tdValue = "<select name=\"" + key + "\" style=width:" + (Integer.parseInt(this.getColumnWidths()[index]) - 3);
        if (textHeight > 0) {
            tdValue = String.valueOf(tdValue) + ";height:" + textHeight;
        }
        if (this.getAttrClasses() != null && !"".equals(this.getAttrClasses()[index])) {
            tdValue = this.getAttrClasses()[index].equals("left") || this.getAttrClasses()[index].equals("right") ? String.valueOf(tdValue) + ";text-align:" + this.getAttrClasses()[index] : String.valueOf(tdValue) + " class=\"" + this.getAttrClasses()[index] + "\"";
        }
        tdValue = String.valueOf(tdValue) + ">";
        if (selectInfoList != null) {
            for (int i = 0; i < selectInfoList.size(); ++i) {
                String[] tempStr = (String[])selectInfoList.get(i);
                tdValue = String.valueOf(tdValue) + "<option value='" + tempStr[0] + "'>" + tempStr[1] + "</option>";
            }
        }
        tdValue = String.valueOf(tdValue) + "</select>";
        return tdValue;
    }

    private void parseTdDisplayType() {
        this.tempDisplayTypes = new int[this.displayTypes.length];
        for (int i = 0; i < this.displayTypes.length; ++i) {
            this.tempDisplayTypes[i] = "text".equals(this.displayTypes[i].toLowerCase()) ? 0 : ("radio".equals(this.displayTypes[i].toLowerCase()) ? 2 : ("rtextbox".equals(this.displayTypes[i].toLowerCase()) ? 3 : ("ltextbox".equals(this.displayTypes[i].toLowerCase()) ? 4 : ("select".equals(this.displayTypes[i].toLowerCase()) ? 5 : ("hidden".equals(this.displayTypes[i].toLowerCase()) ? 6 : ("datebox".equals(this.displayTypes[i].toLowerCase()) ? 7 : ("textboxbut".equals(this.displayTypes[i].toLowerCase()) ? 8 : ("link".equals(this.displayTypes[i].toLowerCase()) ? 9 : ("button".equals(this.displayTypes[i].toLowerCase()) ? 10 : ("no".equals(this.displayTypes[i].toLowerCase()) ? 11 : ("checkno".equals(this.displayTypes[i].toLowerCase()) ? 1 : 0)))))))))));
        }
    }

    private int countColspan(String[] tdHeaders, int startVal) {
        int colspan = 1;
        for (int j = startVal; j < tdHeaders.length - 1 && tdHeaders[j].equals(tdHeaders[j + 1]); ++j) {
            ++colspan;
        }
        return colspan;
    }

    private int countRowspan(String[] trHeaders, int trVal, int tdVal) {
        String[] tdHeaders2;
        String[] tdHeaders1;
        int rowspan = 1;
        for (int j = trVal; j < trHeaders.length - 1 && (tdHeaders1 = PosTagUtil.parseParameters((String)trHeaders[j], (String)"|"))[tdVal].equals((tdHeaders2 = PosTagUtil.parseParameters((String)trHeaders[j + 1], (String)"|"))[tdVal]); ++j) {
            ++rowspan;
        }
        return rowspan;
    }

    private String sumWidth(String[] columnWidths) {
        int width = 0;
        for (int i = 0; i < columnWidths.length; ++i) {
            width += Integer.parseInt(columnWidths[i]);
        }
        return String.valueOf(width);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setInfoName(String infoName) {
        this.infoName = infoName;
        if (this.info.getInfoObject(infoName) != null) {
            this.infoList = (PosRowSet)this.info.getInfoObject(infoName);
            this.infoArrayList = this.infoList.getAllRow();
            this.infoSize = this.infoList.count();
        }
    }

    public String getInfoName() {
        return this.infoName;
    }

    public void setColumnNames(String[] columnNames) {
        if (columnNames != null) {
            this.columnNames = columnNames;
        } else {
            this.columnNames = new String[this.columnWidths.length];
            for (int i = 0; i < this.columnWidths.length; ++i) {
                this.columnNames[i] = "";
            }
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnWidths(String[] columnWidths) {
        this.columnWidths = columnWidths;
    }

    public String[] getColumnWidths() {
        return this.columnWidths;
    }

    public void setHeaderValues(String headerValues) {
        this.headerValues = headerValues;
    }

    public String getHeaderValues() {
        return this.headerValues;
    }

    public void setDisplayTypes(String[] displayTypes) {
        if (displayTypes != null && displayTypes.length > 0) {
            this.displayTypes = displayTypes;
        } else {
            this.displayTypes = new String[this.columnWidths.length];
            for (int i = 0; i < this.columnWidths.length; ++i) {
                this.displayTypes[i] = "null";
            }
        }
    }

    public String[] getDisplayTypes() {
        return this.displayTypes;
    }

    public void setDisplayFormats(String[] displayFormats) {
        this.displayFormats = displayFormats;
    }

    public String[] getDisplayFormats() {
        return this.displayFormats;
    }

    public void setAttributes(String[] attributes) {
        if (attributes != null && attributes.length > 0) {
            this.attributes = attributes;
        } else {
            this.attributes = new String[this.columnWidths.length];
            for (int i = 0; i < this.columnWidths.length; ++i) {
                this.attributes[i] = "null";
            }
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public void setTdEvents(String[] tdEvents) {
        if (tdEvents != null) {
            this.tdEvents = tdEvents;
        } else {
            this.tdEvents = new String[this.columnWidths.length];
            for (int i = 0; i < this.columnWidths.length; ++i) {
                this.tdEvents[i] = "";
            }
        }
    }

    public String[] getTdEvents() {
        return this.tdEvents;
    }

    public void setSelectInfoNames(String[] selectInfoNames) {
        this.selectInfoNames = selectInfoNames;
    }

    public String[] getSelectInfoNames() {
        return this.selectInfoNames;
    }

    public void setDefaultRowCnt(String defaultRowCnt) {
        this.defaultRowCnt = defaultRowCnt;
    }

    public String getDefaultRowCnt() {
        return this.defaultRowCnt;
    }

    public String[] getHeaderClasses() {
        return this.headerClasses;
    }

    public void setHeaderClasses(String[] headerClasses) {
        this.headerClasses = headerClasses;
    }

    public String[] getTrClasses() {
        return this.trClasses;
    }

    public void setTrClasses(String[] trClasses) {
        this.trClasses = trClasses;
    }

    public String[] getTdClasses() {
        return this.tdClasses;
    }

    public void setTdClasses(String[] tdClasses) {
        this.tdClasses = tdClasses;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String[] getAttrClasses() {
        return this.attrClasses;
    }

    public void setAttrClasses(String[] attrClasses) {
        this.attrClasses = attrClasses;
    }

    public String[] getHeaderEvents() {
        return this.headerEvents;
    }

    public void setHeaderEvents(String[] headerEvents) {
        if (headerEvents != null) {
            this.headerEvents = headerEvents;
        } else {
            this.headerEvents = new String[this.columnWidths.length];
            for (int i = 0; i < this.columnWidths.length; ++i) {
                this.headerEvents[i] = "";
            }
        }
    }

    private boolean isPageSet() {
        boolean ispage = false;
        if (this.infoList != null && ((PosPageSet)this.infoList).getPageSize() > 0) {
            ispage = true;
        }
        return ispage;
    }

    private void setCurPage() {
        PosPageSet pageRowSet;
        int curPageInRowSet;
        if (this.infoList != null && (curPageInRowSet = (pageRowSet = (PosPageSet)this.infoList).getCurrentPage()) > 1) {
            this.curPage = curPageInRowSet;
            this.curNo = (this.curPage - 1) * Integer.parseInt(this.defaultRowCnt);
        }
    }

    public void setCurPageName(String curPageName) {
        this.curPageName = curPageName;
    }

    public String getCurPageName() {
        return this.curPageName;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

