/*
 * Decompiled with CFR 0.152.
 */
package core.rfid.data;

import core.rfid.data.ReadXmlMsg;
import core.rfid.data.ReadXmlQuery;
import core.util.DBUtil;
import core.util.LogUtil;
import core.util.PosClassLoaderUtil;
import core.util.UtilFunc;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.NamedNodeMap;

public class SendMsg {
    private static String log_prefix = "[SendMsg]";
    public static String L1CoilDest = "L1CoilDest";
    public static String L1CoilLock = "L1CoilLock";
    public static String L1CoilTakeIn = "L1CoilTakeIn";
    public static String L1CoilTakeOut = "L1CoilTakeOut";
    public static String L1CoilUnLock = "L1CoilUnLock";
    public static String L1RollGrdSch = "L1RollGrdSch";
    public static String L1SlabLock = "L1SlabLock";
    public static String L1SlabTakeIn = "L1SlabTakeIn";
    public static String L1SlabTakeOut = "L1SlabTakeOut";
    public static String L1SlabUnlock = "L1SlabUnlock";
    public static String L2CoilNoIns = "L2CoilNoIns";
    public static String L2MillIns = "L2MillIns";
    public static String L2RhtIns = "L2RhtIns";
    public static String L2RollData = "L2RollData";
    public static String L2RollUnitIns = "L2RollUnitIns";
    public static String L2SlabTakeIn = "L2SlabTakeIn";
    public static String L2_TCPIP = "L2_TCPIP";
    public static String SEND_TCPIP = "SEND_TCPIP";
    public static String RECV_TCPIP = "RECV_TCPIP";

    private static void setLength(StringBuffer sMsg, int newLength) {
        int i = sMsg.length();
        while (i <= newLength) {
            sMsg.append(' ');
            ++i;
        }
        sMsg.setLength(newLength);
    }

    private static String setLength(int len) {
        if (len < 10) {
            return "000" + len;
        }
        if (len < 100) {
            return "00" + len;
        }
        if (len < 1000) {
            return "0" + len;
        }
        return "" + len;
    }

    public static String getSendMsg(Hashtable sendData, String name, boolean flag) {
        StringBuffer sMsg = new StringBuffer();
        StringBuffer lMsg = new StringBuffer(" send data:");
        try {
            InputStream is = PosClassLoaderUtil.getExtendResource("conf/layout/" + name + "-msg.xml").openStream();
            List list = ReadXmlMsg.getMsg(is);
            is.close();
            int count = list.size();
            int iLen = 0;
            int i = 0;
            while (i < count) {
                NamedNodeMap map = (NamedNodeMap)list.get(i);
                String nodeValue = map.getNamedItem("id").getNodeValue();
                String nodeName = map.getNamedItem("desc").getNodeValue();
                int nodeLen = Integer.parseInt(map.getNamedItem("length").getNodeValue());
                if ("TC_LEN".equals(nodeValue)) {
                    nodeValue = "0000";
                } else if ("SYSDATETIME".equals(nodeValue)) {
                    nodeValue = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                } else if (!"NULL".equals(nodeValue)) {
                    if (sendData.get(nodeValue) != null) {
                        nodeValue = sendData.get(nodeValue).toString();
                    }
                } else {
                    nodeValue = "";
                }
                lMsg.append(String.valueOf(nodeName) + "\t[").append(SendMsg.setLength(iLen)).append("  " + SendMsg.setLength(nodeLen) + "]: ").append(nodeValue).append('\n');
                sMsg.append(nodeValue);
                SendMsg.setLength(sMsg, iLen += nodeLen);
                ++i;
            }
            if (flag) {
                sMsg.append('\n');
                ++iLen;
            }
            String sLen = SendMsg.setLength(iLen);
            sMsg.replace(0, 4, sLen);
            lMsg.replace(lMsg.indexOf("]:") + 3, lMsg.indexOf("]:") + 7, sLen).insert(lMsg.indexOf(":") + 1, sMsg.toString());
        }
        catch (IOException e) {
            LogUtil.error(log_prefix, e);
        }
        LogUtil.info(log_prefix, lMsg.toString());
        return sMsg.toString();
    }

    public static ArrayList executeQuery(String queryId) {
        return SendMsg.executeQuery(queryId, null);
    }

    public static ArrayList executeQuery(String queryId, String[] params) {
        ArrayList arrList;
        block10: {
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sqlQuery = null;
            arrList = new ArrayList();
            try {
                InputStream is = PosClassLoaderUtil.getExtendResource("conf/query/select-query.xml").openStream();
                sqlQuery = ReadXmlQuery.getStatement(is, queryId);
                is.close();
                conn = DBUtil.getConnection();
                stmt = conn.prepareStatement(sqlQuery);
                if (params != null) {
                    int i = 0;
                    while (i < params.length) {
                        stmt.setString(i, params[i]);
                        ++i;
                    }
                }
                rs = stmt.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                int count = rsmd.getColumnCount() + 1;
                while (rs.next()) {
                    Hashtable<String, String> ht = new Hashtable<String, String>();
                    int i = 1;
                    while (i < count) {
                        ht.put(rsmd.getColumnLabel(i), UtilFunc.NullToSpace(rs.getString(i), 0));
                        ++i;
                    }
                    arrList.add(ht);
                }
            }
            catch (SQLException se) {
                LogUtil.error("[SQLException] " + sqlQuery);
                DBUtil.close(rs, stmt, conn);
                break block10;
            }
            catch (Exception e) {
                try {
                    LogUtil.error("[Exception] " + e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(rs, stmt, conn);
                    throw throwable;
                }
                DBUtil.close(rs, stmt, conn);
                break block10;
            }
            DBUtil.close(rs, stmt, conn);
        }
        return arrList;
    }

    public static boolean executeUpdate(String queryId) {
        return SendMsg.executeUpdate(queryId, null);
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static boolean executeUpdate(String queryId, String[] params) {
        Connection conn = null;
        PreparedStatement stmt = null;
        String sqlQuery = null;
        try {
            InputStream is = PosClassLoaderUtil.getExtendResource("conf/query/update-query.xml").openStream();
            sqlQuery = ReadXmlQuery.getStatement(is, queryId);
            is.close();
            conn = DBUtil.getConnection();
            stmt = conn.prepareStatement(sqlQuery);
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    stmt.setString(i + 1, params[i]);
                    ++i;
                }
            }
            stmt.executeUpdate();
        }
        catch (SQLException se) {
            LogUtil.error(log_prefix, " [SQLException] " + sqlQuery);
            DBUtil.close(null, stmt, conn);
        }
        catch (Exception e) {
            LogUtil.error(log_prefix, " [Exception] " + e);
            {
                catch (Throwable throwable) {
                    DBUtil.close(null, stmt, conn);
                    throw throwable;
                }
            }
            DBUtil.close(null, stmt, conn);
        }
        DBUtil.close(null, stmt, conn);
        return true;
        return false;
    }
}

