/*
 * Decompiled with CFR 0.152.
 */
package core.rfid.io;

import core.util.LogUtil;
import core.util.PropertyUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class ACUClient {
    private String log_prefix = null;
    private Socket client;
    private InputStream input;
    private OutputStream output;
    private int waitTime = 8000;

    public ACUClient(String log_prefix) {
        this.log_prefix = log_prefix;
        if (PropertyUtil.getProperty("ACU_TIMEOUT") != null) {
            this.waitTime = Integer.parseInt(PropertyUtil.getProperty("ACU_TIMEOUT"));
        }
    }

    public boolean connect(String ip, int port) {
        LogUtil.info(this.log_prefix, " ACUClient ACU IP[" + ip + "], Port[" + port + ']');
        try {
            this.client = new Socket(ip, port);
            if (this.client != null) {
                this.input = this.client.getInputStream();
                this.output = this.client.getOutputStream();
                LogUtil.info(this.log_prefix, " [ACU Server connect success]" + this.client.toString());
                return true;
            }
        }
        catch (UnknownHostException e) {
            LogUtil.error(this.log_prefix, " [ACU Server UnknownHostException] " + e);
        }
        catch (SocketTimeoutException e) {
            LogUtil.error(this.log_prefix, " [ACU Server SocketTimeoutException] " + e);
            this.closeSocket();
        }
        catch (IOException e) {
            LogUtil.error(this.log_prefix, " [ACU Server IOException] " + e);
            this.closeSocket();
        }
        return false;
    }

    public boolean sendPacket(String sbuf) {
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.output));
            bw.write(sbuf);
            bw.flush();
            LogUtil.debug(this.log_prefix, " [Daemon->ACU Success]");
            return true;
        }
        catch (Exception e) {
            LogUtil.error(this.log_prefix, " [Daemon->ACU Exception] " + e.toString());
            return false;
        }
    }

    public boolean sendPacket(byte[] sbuf) {
        try {
            this.output.write(sbuf);
            this.output.flush();
            LogUtil.debug(this.log_prefix, " [Daemon->ACU send success]");
            return true;
        }
        catch (Exception e) {
            LogUtil.error(this.log_prefix, " [Daemon->ACU send exception] " + e.toString());
            return false;
        }
    }

    public byte[] receivePacket() {
        byte[] ret = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.client.setSoTimeout(this.waitTime);
            byte[] buff = new byte[1024];
            int n = this.input.read(buff);
            if (n > 0) {
                out.write(buff, 0, n);
            }
            ret = out.toByteArray();
            this.client.setSoTimeout(0);
        }
        catch (SocketTimeoutException e) {
            LogUtil.error(this.log_prefix, " [ACU->Daemon receive SocketTimeoutException] " + e);
        }
        catch (Exception e) {
            LogUtil.error(this.log_prefix, " [ACU->Daemon receive Exception] " + e);
        }
        return ret;
    }

    public boolean closeSocket() {
        try {
            if (this.client != null) {
                this.client.close();
            }
            LogUtil.debug(this.log_prefix, " [ACU Server close success]");
            return true;
        }
        catch (IOException e) {
            LogUtil.error(this.log_prefix, " [ACU Server close failure]");
            return false;
        }
        finally {
            this.input = null;
            this.output = null;
            this.client = null;
            this.log_prefix = null;
        }
    }
}

