/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import java.awt.Color;
import java.awt.Dimension;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ConsolePane
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private JTextPane textPane = new JTextPane();
    private static ConsolePane console = null;

    public static synchronized ConsolePane getInstance() {
        if (console == null) {
            console = new ConsolePane();
        }
        return console;
    }

    private ConsolePane() {
        this.setViewportView(this.textPane);
        MyPrintStream mySystemOut = new MyPrintStream(System.out, Color.BLACK);
        System.setOut(mySystemOut);
        MyPrintStream mySystemErr = new MyPrintStream(System.err, Color.RED);
        System.setErr(mySystemErr);
        this.textPane.setEditable(true);
        this.setPreferredSize(new Dimension(640, 120));
    }

    private final int getLineCount() {
        return this.textPane.getDocument().getDefaultRootElement().getElementCount();
    }

    private int getLineStartOffset(int line) {
        Element lineElement = this.textPane.getDocument().getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getStartOffset();
    }

    private void replaceRange(String str, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end before start");
        }
        Document doc = this.textPane.getDocument();
        if (doc != null) {
            try {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).replace(start, end - start, str, null);
                } else {
                    doc.remove(start, end - start);
                    doc.insertString(start, str, null);
                }
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    static /* synthetic */ JTextPane access$0(ConsolePane consolePane) {
        return consolePane.textPane;
    }

    static /* synthetic */ int access$1(ConsolePane consolePane) {
        return consolePane.getLineCount();
    }

    static /* synthetic */ int access$2(ConsolePane consolePane, int n) {
        return consolePane.getLineStartOffset(n);
    }

    static /* synthetic */ void access$3(ConsolePane consolePane, String string, int n, int n2) {
        consolePane.replaceRange(string, n, n2);
    }

    class MyPrintStream
    extends PrintStream {
        private Color foreground;
        private int idealLine = 150;
        private int maxExcess = 50;

        MyPrintStream(OutputStream out, Color foreground) {
            super(out, true);
            this.foreground = foreground;
        }

        public void write(byte[] buf, int off, int len) {
            String message = new String(buf, off, len);
            SwingUtilities.invokeLater(new Runnable(this, message){
                final /* synthetic */ MyPrintStream this$1;
                private final /* synthetic */ String val$message;
                {
                    this.this$1 = myPrintStream;
                    this.val$message = string;
                }

                public void run() {
                    try {
                        StyledDocument doc = (StyledDocument)ConsolePane.access$0(MyPrintStream.access$3(this.this$1)).getDocument();
                        Style style = doc.addStyle("StyleName", null);
                        StyleConstants.setForeground(style, MyPrintStream.access$0(this.this$1));
                        doc.insertString(doc.getLength(), this.val$message, style);
                    }
                    catch (BadLocationException doc) {
                        // empty catch block
                    }
                    ConsolePane.access$0(MyPrintStream.access$3(this.this$1)).setCaretPosition(ConsolePane.access$0(MyPrintStream.access$3(this.this$1)).getDocument().getLength());
                    int excess = ConsolePane.access$1(MyPrintStream.access$3(this.this$1)) - MyPrintStream.access$1(this.this$1);
                    if (excess >= MyPrintStream.access$2(this.this$1)) {
                        ConsolePane.access$3(MyPrintStream.access$3(this.this$1), "", 0, ConsolePane.access$2(MyPrintStream.access$3(this.this$1), excess));
                    }
                }
            });
        }

        static /* synthetic */ Color access$0(MyPrintStream myPrintStream) {
            return myPrintStream.foreground;
        }

        static /* synthetic */ int access$1(MyPrintStream myPrintStream) {
            return myPrintStream.idealLine;
        }

        static /* synthetic */ int access$2(MyPrintStream myPrintStream) {
            return myPrintStream.maxExcess;
        }

        static /* synthetic */ ConsolePane access$3(MyPrintStream myPrintStream) {
            return myPrintStream.ConsolePane.this;
        }
    }
}

