/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import core.rfid.db.DBPool;
import core.rfid.db.DBPoolMgr;
import core.util.LogUtil;
import core.util.PropertyUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBUtil {
    private DBUtil() {
    }

    public static Connection getConnection() throws SQLException {
        DBPool pool = DBPoolMgr.getPool(PropertyUtil.getProperty("DB_POOL_NAME"));
        Connection con = pool.getConnection();
        con.setAutoCommit(false);
        return con;
    }

    public static void close(ResultSet rset) {
        try {
            if (rset != null) {
                rset.close();
            }
        }
        catch (SQLException e) {
            LogUtil.error(e.toString());
        }
    }

    public static void close(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LogUtil.error(e.toString());
        }
    }

    public static void close(Connection con) {
        try {
            if (con != null) {
                con.commit();
            }
        }
        catch (SQLException e) {
            LogUtil.error(e);
        }
        try {
            if (con != null) {
                con.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            LogUtil.error(e);
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            LogUtil.error(e);
        }
    }

    public static void close(ResultSet rs, Statement stmt, Connection conn) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            LogUtil.error(e.toString());
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            LogUtil.error(e.toString());
        }
        try {
            if (conn != null) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            LogUtil.error(e);
        }
        try {
            if (conn != null) {
                conn.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            LogUtil.error(e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            LogUtil.error(e);
        }
    }

    public static void rollbackTransaction(Connection conn) {
        try {
            conn.rollback();
        }
        catch (Exception e) {
            LogUtil.error(e);
        }
    }

    public static void commitTransaction(Connection conn) {
        try {
            conn.commit();
        }
        catch (Exception e) {
            LogUtil.error(e.toString());
        }
    }
}

