/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import core.util.PosClassLoaderUtil;
import core.util.PropertyUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;

public class LogUtil {
    static Logger log = null;

    static {
        try {
            log = Logger.getRootLogger();
            log.setLevel(Level.DEBUG);
            PropertyConfigurator.configure((URL)PosClassLoaderUtil.getExtendResource(PropertyUtil.getProperty("LOG_FILE")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public LogUtil() {
        System.out.println("LoggerUtil [RootLogger] Constructor.");
    }

    public LogUtil(Class clazz) {
        String loggerName = clazz.getName();
        loggerName = loggerName.substring(loggerName.lastIndexOf(46) + 1);
        log = Logger.getLogger((String)loggerName);
        try {
            String logPattern = "[%d{MM/dd HH:mm:ss}][%-5p] %m%n";
            DailyRollingFileAppender appender = new DailyRollingFileAppender((Layout)new PatternLayout(logPattern), "./logs/" + loggerName + "/" + loggerName + ".log", "yyyy-MM-dd-HH");
            log.addAppender((Appender)appender);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("LoggerUtil [" + loggerName + "] Logger Constructor.");
    }

    public LogUtil(String loggerName) {
        log = Logger.getLogger((String)loggerName);
    }

    public static void debug(String message) {
        if (log != null) {
            log.debug((Object)message);
        } else {
            System.out.println("log is null");
        }
    }

    public static void error(String message) {
        if (log != null) {
            log.error((Object)message);
        }
    }

    public static void error(Exception error) {
        if (log != null) {
            log.error((Object)error);
        }
    }

    public static void info(String message) {
        if (log != null) {
            log.info((Object)message);
        }
    }

    public static void warn(String message) {
        if (log != null) {
            log.warn((Object)message);
        }
    }

    public static void debug(String log_prefix, String message) {
        if (log != null) {
            log.debug((Object)(String.valueOf(log_prefix) + message));
        } else {
            System.out.println(String.valueOf(log_prefix) + "log is null");
        }
    }

    public static void error(String log_prefix, String message) {
        if (log != null) {
            log.error((Object)(String.valueOf(log_prefix) + message));
        }
    }

    public static void error(String log_prefix, Exception error) {
        if (log != null) {
            log.error((Object)(String.valueOf(log_prefix) + error));
        }
    }

    public static void info(String log_prefix, String message) {
        if (log != null) {
            log.info((Object)(String.valueOf(log_prefix) + message));
        }
    }

    public static void warn(String log_prefix, String message) {
        if (log != null) {
            log.warn((Object)(String.valueOf(log_prefix) + message));
        }
    }
}

