/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.ui.tags;

import com.posdata.glue.ui.tags.PosEntry;
import com.posdata.glue.ui.tags.PosFolder;
import com.posdata.glue.ui.tags.PosTree;
import com.posdata.glue.ui.tags.ShowTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class PosShowTreeTag
extends PosTree {
    private static final String TREE_TYPE_DB = "DB";
    private static final String TREE_TYPE_VO = "VO";
    private static final String TREE_TYPE_JSP = "JSP";
    private static final String TREE_TYPE_MES = "MES";
    private static final String TREE_TYPE_LIST = "LIST";
    private static final String DEFAULT_IMAGE_SRC = "/img";
    private static final String DEFAULT_JS_SRC = "/js";
    private static final String DEFAULT_TARGET = "_blank";
    private static final String DEFAULT_TREENAME = "treelist";
    private static final String DEFAULT_INFO_NAME = "TREE_INFO";
    private static final String DEFAULT_INFO_LINK = "LINK_INFO";
    private ArrayList indexTable = new ArrayList(10);
    private Collection treeList;
    private String treeType = "JSP";
    private String clickEvent = null;
    private String imgsrc = "/img";
    private String jssrc = "/js";
    private String target = "_blank";
    private String infoName = "TREE_INFO";
    private String name = "treelist";
    private ArrayList mesMenu = null;
    private HashMap mesLink = null;
    private String mesParam = null;

    public void init() {
        this.treeList = null;
        this.treeType = TREE_TYPE_JSP;
        this.clickEvent = null;
        this.imgsrc = DEFAULT_IMAGE_SRC;
        this.jssrc = DEFAULT_JS_SRC;
        this.target = DEFAULT_TARGET;
        this.infoName = DEFAULT_INFO_NAME;
        this.name = DEFAULT_TREENAME;
        this.mesMenu = null;
        this.mesLink = null;
        this.mesParam = null;
    }

    public int doStartTag() throws JspException {
        if (this.treeType.equals(TREE_TYPE_DB)) {
            ShowTree tree = new ShowTree(this.infoName, this.pageContext.getRequest());
            tree.doStartTagWithDB(this.indexTable);
        } else if (this.treeType.equals(TREE_TYPE_LIST)) {
            ShowTree tree = new ShowTree(this.infoName);
            tree.doStartTagWithList(this.indexTable, this.treeList, this.target);
        } else {
            this.doStartTagWithJsp();
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            this.display();
            this.init();
            if (!this.indexTable.isEmpty()) {
                this.indexTable.clear();
            }
        }
        catch (IOException e) {
            throw new JspException("PosShowTreeTag: doEndTag Exception : " + e);
        }
        return 6;
    }

    private void doStartTagWithJsp() {
        PosFolder root = new PosFolder();
        root.level = this.level;
        root.desc = this.desc;
        root.link = this.link;
        root.value = this.value;
        root.parent = null;
        this.entry = root;
        this.indexTable.add(0, root);
    }

    public void addEntry(PosEntry entry) {
        this.indexTable.add(entry);
    }

    public PosEntry getEntry(int index) throws IndexOutOfBoundsException {
        return (PosEntry)this.indexTable.get(index);
    }

    private PosEntry getRoot() {
        try {
            return (PosEntry)this.indexTable.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private void display() throws IOException {
        PosEntry root = this.getRoot();
        JspWriter out = this.pageContext.getOut();
        if (root != null) {
            out.println("<script language=javascript src=" + this.jssrc + "></script>");
            out.println("<script language=javascript>");
            out.println("<!--");
            out.println("var " + this.name + " = new TreeList();");
            out.println(this.name + ".setName(\"" + this.name + "\")");
            out.println(this.name + ".setImages(new TreeImages(\"" + this.imgsrc + "\"));");
            if (this.clickEvent != null) {
                out.println(this.name + ".OnClick=" + this.clickEvent + ";");
            }
            root.draw(out, this.name, "a");
            out.println(this.name + ".display();");
            out.println("//-->");
            out.println("</script>");
        }
    }

    public void setMesMenu(ArrayList mesMenu) {
        this.mesMenu = mesMenu;
    }

    public void setMesLink(HashMap mesLink) {
        this.mesLink = mesLink;
    }

    public void setMesParam(String mesParam) {
        this.mesParam = mesParam;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.treeType = type;
    }

    public void setImgsrc(String src) {
        this.imgsrc = src;
    }

    public void setOnclick(String event) {
        this.clickEvent = event;
    }

    public void setJssrc(String jssrc) {
        this.jssrc = jssrc;
    }

    public void setTreelist(Collection treelist) {
        this.treeList = treelist;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public void setInfoName(String infoName) {
        this.infoName = infoName;
    }
}

