/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.ui.tags;

import com.posdata.glue.dao.vo.PosRow;
import com.posdata.glue.ui.tags.ShowOption;
import java.util.ArrayList;
import javax.servlet.ServletRequest;

public class ShowSelectList
extends ShowOption {
    protected String totalName;
    protected String totalValue;
    protected String selectedValue;
    protected int selectedOptionIdx = -1;
    protected int accumulatedSelectedOptionIdx;

    public ShowSelectList() {
    }

    public ShowSelectList(ServletRequest request) {
        this.info.setRequest(request);
    }

    public String getSelectedValue() {
        return this.selectedValue;
    }

    public String getTotalName() {
        return this.totalName;
    }

    public void setTotalName(String totalName) {
        this.totalName = totalName;
    }

    public String getTotalValue() {
        return this.totalValue;
    }

    public void setTotalValue(String totalValue) {
        this.totalValue = totalValue;
    }

    public int getSelectedOptionIdx() {
        if (this.getTotalName() != null) {
            return this.accumulatedSelectedOptionIdx + this.selectedOptionIdx - 1;
        }
        return this.accumulatedSelectedOptionIdx + this.selectedOptionIdx;
    }

    public String build() {
        String tmpString = null;
        ArrayList tmpSelectedRowArray = null;
        ArrayList<String> tmpOptionValue = new ArrayList<String>(10);
        StringBuffer strHtml = new StringBuffer(1024);
        boolean isFirstScreen = false;
        if (!this.checkAttribute()) {
            return null;
        }
        this.appendStrBuffer(strHtml, this.buildLabel());
        this.isRepeated = true;
        this.appendNewLine(strHtml);
        this.appendStrBuffer(strHtml, this.buildStartSelectTag());
        if (!this.getIsStatic()) {
            tmpSelectedRowArray = this.getSelectedRow(this.getKeyAttribute(), this.getKeyValue());
            isFirstScreen = this.isFirstScreen();
        }
        String tmpOptionName = null;
        String tmpValueName = null;
        boolean tmpIsSelected = false;
        int optionNum = 0;
        if (this.getTotalName() != null) {
            this.appendNewLine(strHtml);
            strHtml.append("  ");
            tmpString = this.buildOptionTag(this.getTotalName(), this.getTotalValue(), tmpIsSelected, optionNum++);
            this.appendStrBuffer(strHtml, tmpString);
        }
        if (tmpSelectedRowArray != null) {
            int tmpLength = tmpSelectedRowArray.size();
            for (int rowIndex = 0; rowIndex < tmpLength; ++rowIndex) {
                PosRow row = (PosRow)tmpSelectedRowArray.get(rowIndex);
                if (row == null || this.getNameAttribute() == null) continue;
                tmpOptionName = this.getBottomObject(row, this.getNameAttribute());
                tmpOptionValue.add(tmpOptionName);
                tmpValueName = this.getBottomObject(row, this.getValueAttribute());
                tmpIsSelected = this.isSelected(tmpOptionName, tmpValueName, this.getDefaultSelectionValueArray());
                this.appendNewLine(strHtml);
                strHtml.append("  ");
                tmpString = this.buildOptionTag(tmpOptionName, tmpValueName, tmpIsSelected, optionNum++, isFirstScreen);
                this.appendStrBuffer(strHtml, tmpString);
            }
            if (this.selectedOptionIdx == -1 && tmpOptionValue.size() > 0) {
                this.selectedValue = (String)tmpOptionValue.get(0);
            }
        } else {
            for (int idx = 0; idx < this.getStaticNameArray().length; ++idx) {
                tmpOptionName = this.getStaticName(idx);
                tmpValueName = this.getStaticValue(idx);
                tmpIsSelected = this.isSelected(tmpOptionName, tmpValueName, this.getDefaultSelectionValueArray());
                this.appendNewLine(strHtml);
                strHtml.append("  ");
                tmpString = this.buildOptionTag(tmpOptionName, tmpValueName, tmpIsSelected, optionNum++, isFirstScreen);
                this.appendStrBuffer(strHtml, tmpString);
            }
        }
        this.appendNewLine(strHtml);
        strHtml.append(this.buildEndSelectTag());
        return strHtml.toString();
    }

    public String buildStartSelectTag() {
        String tmpString = null;
        StringBuffer strHtml = new StringBuffer(1024);
        strHtml.append("<select");
        tmpString = this.makeAttribute(" name", this.getName());
        if (tmpString == null && (tmpString = this.makeAttribute(" name", this.getLabel())) == null) {
            tmpString = this.makeAttribute(" name", "select1");
        }
        this.appendStrBuffer(strHtml, tmpString);
        tmpString = this.makeAttribute(" class", this.getCls());
        if (tmpString == null) {
            tmpString = this.makeAttribute(" class", "adf");
        }
        this.appendStrBuffer(strHtml, tmpString);
        tmpString = this.makeAttribute(" ", this.getScript());
        if (tmpString == null) {
            tmpString = this.makeAttribute(" ", "");
        }
        this.appendStrBuffer(strHtml, tmpString);
        tmpString = this.makeAttribute(" style", this.getStyle());
        if (tmpString == null) {
            tmpString = this.makeAttribute(" style", "");
        }
        this.appendStrBuffer(strHtml, tmpString);
        if (this.getExtraParameterArray() != null && this.getExtraParameterArray().length > 0) {
            String tmpExtraParameter = this.getExtraParameter(0);
            strHtml.append(" " + tmpExtraParameter);
        }
        strHtml.append(">");
        return strHtml.toString();
    }

    public String buildOptionTag(String value, String displayValue, boolean selected, int idx) {
        return this.buildOptionTag(value, displayValue, selected, idx, false);
    }

    public String buildOptionTag(String value, String displayValue, boolean selected, int idx, boolean isFirstScreen) {
        if (displayValue != null && displayValue.length() > 0) {
            String tmpString = null;
            StringBuffer strHtml = new StringBuffer(1024);
            strHtml.append("<option");
            tmpString = this.makeAttribute(" value", value);
            this.appendStrBuffer(strHtml, tmpString);
            if (this.getIsRequestFirst() && !isFirstScreen) {
                String tmpStr = this.getRequestedString(this.getName());
                if (tmpStr != null && tmpStr.length() > 0 && (tmpStr.equalsIgnoreCase(value) || tmpStr.equalsIgnoreCase(displayValue))) {
                    this.selectedOptionIdx = idx;
                    this.selectedValue = value;
                    strHtml.append(" selected");
                }
            } else if (selected) {
                this.selectedOptionIdx = idx;
                this.selectedValue = value;
                strHtml.append(" selected");
            }
            strHtml.append(">");
            strHtml.append(displayValue);
            strHtml.append("</option>");
            return strHtml.toString();
        }
        return null;
    }

    public String buildEndSelectTag() {
        return "</select>";
    }

    public boolean isFirstScreen() {
        String tmpStr = this.getRequestedString(this.getName());
        return tmpStr == null;
    }
}

