/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.ui.tags;

import com.posdata.glue.ui.tags.GetInfoBean;
import com.posdata.glue.ui.tags.PosEntry;
import com.posdata.glue.ui.tags.PosFolder;
import com.posdata.glue.ui.tags.PosItem;
import com.posdata.glue.ui.tags.PosTreeData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;

public class ShowTree {
    private static final String MES_LEVEL = "Level";
    private static final String MES_MENU_ID = "MenuId";
    private static final String MES_ENTRY_SEQ = "EntrySequence";
    private static final String MES_PROMPT = "Prompt";
    private static final String MES_SUB_MENU_ID = "SubMenuId";
    private static final String MES_FUNCTION_ID = "FunctionId";
    private static final String MES_FUNCTION_NAME = "FunctionName";
    private static final String MES_LINK = "WebHtmlCall";
    private GetInfoBean info = new GetInfoBean();
    private String infoName;

    public ShowTree() {
    }

    public ShowTree(String infoName, ServletRequest request) {
        if (infoName != null && request != null) {
            this.infoName = infoName;
            this.info.setRequest(request);
        }
    }

    public ShowTree(String infoName) {
        this.infoName = infoName;
    }

    public boolean doStartTagWithDB(ArrayList indexTable) throws JspException {
        boolean bRet = false;
        try {
            Collection co;
            if (this.info != null && (co = (Collection)this.info.getInfoObject(this.infoName)) != null) {
                bRet = this.doStartTagWithList(indexTable, co, "");
            }
        }
        catch (Exception ioe) {
            throw new JspException("ShowTree: doStartTagWithDB Exception : " + ioe);
        }
        return bRet;
    }

    public boolean doStartTagWithList(ArrayList indexTable, Collection entries, String target) {
        PosEntry entry;
        PosTreeData td;
        Hashtable<String, String> ht = new Hashtable<String, String>(10);
        int nextId = 0;
        if (indexTable == null || entries == null || entries.size() == 0) {
            return false;
        }
        Iterator it = entries.iterator();
        if (it.hasNext()) {
            td = (PosTreeData)it.next();
            if (td.getLevel() != 0) {
                return false;
            }
            entry = new PosFolder();
            entry.desc = td.getDesc();
            entry.link = td.getLink();
            entry.level = td.getLevel();
            entry.value = td.getValue();
            indexTable.add(0, entry);
            ht.put(String.valueOf(td.getId()), String.valueOf(nextId));
            ++nextId;
        } else {
            return false;
        }
        while (it.hasNext()) {
            td = (PosTreeData)it.next();
            int pid = td.getPid();
            Object oId = ht.get(String.valueOf(pid));
            if (oId == null) continue;
            PosFolder folder = (PosFolder)indexTable.get(Integer.parseInt((String)oId));
            if (td.isFolder()) {
                entry = new PosFolder();
            } else {
                entry = new PosItem();
                if (target != null && target.length() > 0) {
                    ((PosItem)entry).setTarget(target);
                }
            }
            entry.desc = td.getDesc();
            entry.link = td.getLink();
            entry.level = td.getLevel();
            entry.value = td.getValue();
            folder.addChild(entry);
            indexTable.add(nextId, entry);
            ht.put(String.valueOf(td.getId()), String.valueOf(nextId));
            ++nextId;
        }
        return true;
    }
}

