/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.ui.tags.util;

import com.posdata.glue.ui.tags.util.PosCalendarIF;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class PosCalendarUtil
implements PosCalendarIF {
    static FileInputStream fis = null;
    SimpleDateFormat formatter = null;
    Calendar calendar = null;
    String separator = "-";
    TimeZone tz = null;
    int country = 1;
    Locale locale = null;

    public PosCalendarUtil() {
        this.jInit(0, null, 1, null, null);
    }

    public PosCalendarUtil(int pYear, int pMonth, int pDay) {
        this.jInit(1, null, 1, null, null);
        this.calendar.set(pYear, pMonth - 1, pDay);
    }

    public PosCalendarUtil(int pCountry) {
        this.jInit(0, null, 1, null, null);
    }

    public PosCalendarUtil(int pCountry, int pYear, int pMonth, int pDay) {
        this.jInit(0, null, 1, null, null);
        this.calendar.set(pYear, pMonth - 1, pDay);
    }

    public PosCalendarUtil(int pCountry, String pTZ) {
        this.jInit(0, null, 1, null, null);
    }

    public PosCalendarUtil(int pCountry, String pTZ, int pYear, int pMonth, int pDay) {
        this.jInit(0, null, 1, null, null);
        this.calendar.set(pYear, pMonth - 1, pDay);
    }

    public PosCalendarUtil(int pCountry, String pContinent, String pLocal) {
        this.jInit(0, null, 1, null, null);
    }

    private String getApplicationInfo() {
        return new String("PosCalendarUtil");
    }

    private void jInit(int pParameter, String pTZ, int pCountry, String pContinent, String pLocal) {
        switch (pParameter) {
            case 0: {
                this.tz = TimeZone.getTimeZone("Asia/Seoul");
                this.calendar = Calendar.getInstance(this.tz, Locale.KOREA);
                this.country = 1;
                this.locale = Locale.KOREA;
                break;
            }
            case 1: {
                switch (pCountry) {
                    default: 
                }
                this.tz = TimeZone.getTimeZone("Asia/Seoul");
                this.calendar = Calendar.getInstance(this.tz, Locale.KOREA);
                this.country = 1;
                this.locale = Locale.KOREA;
                break;
            }
            case 2: {
                this.tz = TimeZone.getTimeZone(pTZ);
                switch (pCountry) {
                    default: 
                }
                this.calendar = Calendar.getInstance(this.tz, Locale.KOREA);
                this.country = 1;
                this.locale = Locale.KOREA;
                break;
            }
            case 3: {
                String nTZ = pContinent + "/" + pLocal;
                this.tz = TimeZone.getTimeZone(nTZ);
                switch (pCountry) {
                    default: 
                }
                this.calendar = Calendar.getInstance(this.tz, Locale.KOREA);
                this.country = 1;
                this.locale = Locale.KOREA;
                break;
            }
            default: {
                this.tz = TimeZone.getTimeZone("Asia/Seoul");
                this.calendar = Calendar.getInstance(this.tz, Locale.KOREA);
                this.country = 1;
                this.locale = Locale.KOREA;
            }
        }
    }

    public String getYear() {
        this.formatter = new SimpleDateFormat("yyyy");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getMonth() {
        this.formatter = new SimpleDateFormat("MM");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getDay() {
        this.formatter = new SimpleDateFormat("dd");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getHour() {
        this.formatter = new SimpleDateFormat("HH");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getMinute() {
        this.formatter = new SimpleDateFormat("mm");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getSecond() {
        this.formatter = new SimpleDateFormat("ss");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public int getDateValue(int pNumber) {
        int nNumber = 0;
        switch (pNumber) {
            case 1: {
                nNumber = this.calendar.get(1);
                break;
            }
            case 2: {
                nNumber = this.calendar.get(2) + 1;
                break;
            }
            case 5: {
                nNumber = this.calendar.get(5);
                break;
            }
            case 10: 
            case 11: {
                nNumber = this.calendar.get(11);
                break;
            }
            case 12: {
                nNumber = this.calendar.get(12);
                break;
            }
            case 13: {
                nNumber = this.calendar.get(13);
                break;
            }
            default: {
                nNumber = 0;
            }
        }
        return nNumber;
    }

    public void setDate(int pYear, int pMonth, int pDay) {
        this.calendar.set(pYear, pMonth - 1, pDay);
    }

    public void setYear(int pYear) {
        this.calendar.add(1, pYear);
    }

    public void setMonth(int pMonth) {
        this.calendar.add(2, pMonth);
    }

    public void setDay(int pDay) {
        this.calendar.add(5, pDay);
    }

    public void setHour(int pHour) {
        this.calendar.add(11, pHour);
    }

    public void setMinute(int pMinute) {
        this.calendar.add(12, pMinute);
    }

    public void setSecond(int pSecond) {
        this.calendar.add(13, pSecond);
    }

    public String getDateString() {
        this.formatter = new SimpleDateFormat("yyyy-MM-dd");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getDateString(String pSeparator) {
        this.formatter = new SimpleDateFormat("yyyy" + pSeparator + "MM" + pSeparator + "dd");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getTimeString() {
        this.formatter = new SimpleDateFormat("HH/mm/ss");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getTimeString(String pSeparator) {
        this.formatter = new SimpleDateFormat("HH" + pSeparator + "mm" + pSeparator + "ss");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getDateTimeString() {
        this.formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getDateTimeString(String pStr) {
        this.formatter = new SimpleDateFormat("yyyy" + pStr + "MM" + pStr + "dd" + pStr + "HH" + pStr + "mm" + pStr + "ss" + pStr + "SSS");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getNextDateString(int pNumber, int pPlus) {
        switch (pNumber) {
            case 1: {
                this.setYear(pPlus);
                break;
            }
            case 2: {
                this.setMonth(pPlus);
                break;
            }
            case 5: {
                this.setDay(pPlus);
                break;
            }
            case 10: 
            case 11: {
                this.setHour(pPlus);
                break;
            }
            case 12: {
                this.setMinute(pPlus);
                break;
            }
            case 13: {
                this.setSecond(pPlus);
                break;
            }
        }
        this.formatter = new SimpleDateFormat("yyyy-MM-dd");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public String getNextDateString(int pNumber, int pPlus, String pSeparator) {
        switch (pNumber) {
            case 1: {
                this.setYear(pPlus);
                break;
            }
            case 2: {
                this.setMonth(pPlus);
                break;
            }
            case 5: {
                this.setDay(pPlus);
                break;
            }
            case 10: 
            case 11: {
                this.setHour(pPlus);
                break;
            }
            case 12: {
                this.setMinute(pPlus);
                break;
            }
            case 13: {
                this.setSecond(pPlus);
                break;
            }
        }
        this.formatter = new SimpleDateFormat("yyyy" + pSeparator + "MM" + pSeparator + "dd");
        return new String(this.formatter.format(this.calendar.getTime()));
    }

    public int checkNextYear() {
        this.calendar.add(2, 1);
        int nYear = this.calendar.get(1);
        this.calendar.add(2, -1);
        return nYear;
    }

    public int checkNextMonth() {
        this.calendar.add(5, 1);
        int nMonth = this.calendar.get(2);
        this.calendar.add(5, -1);
        return nMonth;
    }

    public int checkNextYear(int pPlus) {
        this.calendar.add(2, pPlus);
        int nYear = this.calendar.get(1);
        this.calendar.add(2, -pPlus);
        return nYear;
    }

    public int checkNextMonth(int pPlus) {
        this.calendar.add(5, pPlus);
        int nMonth = this.calendar.get(2);
        this.calendar.add(5, -pPlus);
        return nMonth;
    }

    public int checkFirstDay() {
        int nDay = this.calendar.get(5);
        this.calendar.set(5, 1);
        int nWeek = this.calendar.get(7);
        this.calendar.set(5, nDay);
        return nWeek;
    }

    public int checkLastDay() {
        int lnDay_new = 0;
        int lnMonth = this.calendar.get(2);
        int lnDay = this.calendar.get(5);
        for (int ii = lnDay + 1; ii < 31; ++ii) {
            this.calendar.set(5, ii);
            int lnMonth_new = this.calendar.get(2);
            lnDay_new = this.calendar.get(5);
            if (lnMonth == lnMonth_new) continue;
            this.calendar.set(2, lnMonth);
            this.calendar.set(5, lnDay);
            break;
        }
        return lnDay_new;
    }

    public int checkLastDay(int pMonth) {
        int lnDay_buf = 0;
        int lnMonth_old = this.calendar.get(2);
        int lnDay_old = this.calendar.get(5);
        this.calendar.set(2, pMonth - 1);
        int lnMonth = this.calendar.get(2);
        for (int ii = 28; ii <= 31; ++ii) {
            this.calendar.set(5, ii);
            int lnMonth_new = this.calendar.get(2);
            int lnDay_new = this.calendar.get(5);
            if (lnMonth != lnMonth_new) {
                this.calendar.set(2, lnMonth_old);
                this.calendar.set(5, lnDay_old);
                break;
            }
            lnDay_buf = lnDay_new;
        }
        return lnDay_buf;
    }

    public void toKorea() {
        if (this.country != 1) {
            this.tz = TimeZone.getTimeZone("Asia/Seoul");
            Calendar cals = Calendar.getInstance(this.tz, Locale.KOREA);
            cals.setTime(this.calendar.getTime());
            this.calendar = cals;
            this.country = 1;
        }
    }

    public void toKorea(String pTZ) {
        if (this.country != 1) {
            this.tz = TimeZone.getTimeZone(pTZ);
            Calendar cals = Calendar.getInstance(this.tz, Locale.KOREA);
            cals.setTime(this.calendar.getTime());
            this.calendar = cals;
            this.country = 1;
        }
    }

    public void toKorea(String pContinent, String pLocal) {
        if (this.country != 1) {
            String nTZ = pContinent + "/" + pLocal;
            this.tz = TimeZone.getTimeZone(nTZ);
            Calendar cals = Calendar.getInstance(this.tz, Locale.KOREA);
            cals.setTime(this.calendar.getTime());
            this.calendar = cals;
            this.country = 1;
        }
    }
}

