/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.net;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import oracle.i18n.net.MimeUtility;
import oracle.i18n.util.GDKMessage;

public class URLDecoder {
    private static final byte M_C_SPACE = 32;
    private static final byte M_C_PLUS = 43;
    private static final byte M_C_PERCENT = 37;
    private static final float JDK_VERS;

    private URLDecoder() {
    }

    public static String decode(String string) {
        String string2 = null;
        try {
            string2 = URLDecoder.decode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public static String decode(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes("ISO-8859-1");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        int n = 0;
        while (n < byArray.length) {
            switch (byArray[n]) {
                case 43: {
                    byteArrayOutputStream.write(32);
                    break;
                }
                case 37: {
                    byte by;
                    byte by2;
                    if (n + 2 >= byArray.length || (by2 = MimeUtility.hex2val(byArray[n + 1])) == -1 || (by = MimeUtility.hex2val(byArray[n + 2])) == -1) {
                        throw new NumberFormatException(GDKMessage.getMessage(5206, (Object)(byArray[n + 1] + "," + byArray[n + 2])));
                    }
                    byteArrayOutputStream.write((by2 << 4) + by);
                    n += 2;
                    break;
                }
                default: {
                    byteArrayOutputStream.write(byArray[n]);
                }
            }
            ++n;
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return MimeUtility.toString(byArray2, 0, byArray2.length, string2);
    }

    static {
        String string = System.getProperty("java.version").substring(0, 3);
        try {
            JDK_VERS = new Float(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("failed to get the JDK version: " + string);
        }
    }
}

