/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.OraCharsetDecoder;
import oracle.i18n.text.OraCharsetEncoder;
import oracle.i18n.text.converter.CharacterConverterOGS;

class OraCharsetWithConverter
extends OraCharset {
    private CharacterConverterOGS charConverter;

    OraCharsetWithConverter(String string, int n, CharacterConverterOGS characterConverterOGS) {
        super(string, n);
        this.charConverter = characterConverterOGS;
    }

    static OraCharset getInstance(String string, int n) {
        CharacterConverterOGS characterConverterOGS = (CharacterConverterOGS)CharacterConverterOGS.getInstance(n);
        return characterConverterOGS == null ? null : new OraCharsetWithConverter(string, n, characterConverterOGS);
    }

    public CharsetDecoder newDecoder() {
        return new OraCharsetDecoder(this, this.charConverter.getAverageRatio(), this.charConverter.getMaxRatio());
    }

    public CharsetEncoder newEncoder() {
        if (this.charConverter.getGroupId() == 6 || this.charConverter.getGroupId() == 3) {
            CharacterConverterOGS characterConverterOGS = this.charConverter;
            char c = characterConverterOGS.getOraChar2ByteRep();
            return new OraCharsetEncoder(this, 1.0f / this.charConverter.getAverageRatio(), this.charConverter.getMaxBytesRatio(), new byte[]{(byte)(c >>> 8), (byte)c});
        }
        return new OraCharsetEncoder(this, 1.0f / this.charConverter.getAverageRatio(), this.charConverter.getMaxBytesRatio());
    }

    String toStringWithReplacement(byte[] byArray, int n, int n2) {
        return this.charConverter.toUnicodeStringWithReplacement(byArray, n, n2);
    }

    String toString(byte[] byArray, int n, int n2) throws SQLException {
        return this.charConverter.toUnicodeString(byArray, n, n2);
    }

    byte[] convertWithReplacement(String string) {
        return this.charConverter.toOracleStringWithReplacement(string);
    }

    byte[] convert(String string) throws SQLException {
        return this.charConverter.toOracleString(string);
    }
}

