/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public abstract class CharacterConverterLC
extends CharacterConverterOGS {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int MAX_7BIT = 127;
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int ORACHARWITHLCWIDTH = 32;
    static final int BYTEWIDTH = 8;
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int LOW16BITMASK = 65535;
    static final int BELOW_CJK = 12287;
    static final int LEADINGCODEWIDTH = 16;
    static final int LEADINGCODESHIFT = 16;
    static final int LEADINGCODEMASK = 65535;
    static final int LCINDEXWIDTH = 4;
    static final int LCINDEXMASK = 15;
    static final int LCINDEXFACTOR = 2;
    static final int MAXBYTEPERCHAR = 4;
    public char[][] m_ucsCharLeadingCode = null;
    public char[] m_ucsCharLevel1 = null;
    public int[] m_ucsCharLevel2 = null;
    public int m_ucsCharReplacement = 0;
    public char m_1ByteOraCharReplacement = '\u0000';
    public char m_2ByteOraCharReplacement = '\u0000';
    public char[] m_oraCharLevel1 = null;
    public int[] m_oraCharLevel2 = null;
    public char[] m_oraCharSurrogateLevel = null;

    CharacterConverterLC() {
        this.m_groupId = 8;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 4.0f;
    }

    public char[] getLeadingCodes() {
        char[] cArray = new char[this.m_ucsCharLeadingCode.length];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = this.m_ucsCharLeadingCode[n][0];
            ++n;
        }
        return cArray;
    }

    int toUnicode(int n) throws SQLException {
        int n2 = 0;
        int n3 = n >> 16 & 0xFFFF;
        int n4 = 0;
        while (n4 < this.m_ucsCharLeadingCode.length) {
            if (n3 == this.m_ucsCharLeadingCode[n4][0]) {
                n2 = this.m_ucsCharLeadingCode[n4][1];
                break;
            }
            ++n4;
        }
        if (n4 == this.m_ucsCharLeadingCode.length) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        int n5 = (n >> 8 & 0xFF) + n2;
        int n6 = n & 0xFF;
        if (this.m_ucsCharLevel1[n5] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6] == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        int n7 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6];
        return n7;
    }

    int toUnicodeWithReplacement(int n) {
        int n2 = 0;
        int n3 = n >> 16 & 0xFFFF;
        int n4 = 0;
        while (n4 < this.m_ucsCharLeadingCode.length) {
            if (n3 == this.m_ucsCharLeadingCode[n4][0]) {
                n2 = this.m_ucsCharLeadingCode[n4][1];
                break;
            }
            ++n4;
        }
        if (n4 == this.m_ucsCharLeadingCode.length) {
            return this.m_ucsCharReplacement;
        }
        int n5 = (n >> 8 & 0xFF) + n2;
        int n6 = n & 0xFF;
        int n7 = this.m_ucsCharLevel1[n5] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6] : this.m_ucsCharReplacement;
        return n7;
    }

    int toOracleCharacter(char c, char c2) throws SQLException {
        int n = -1;
        if (c2 != '\u0000') {
            int n2 = c >>> 8 & 0xFF;
            int n3 = c & 0xFF;
            int n4 = c2 >>> 8 & 0xFF;
            int n5 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n2] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c >>> 8 & 0xFF;
            int n7 = c & 0xFF;
            if (this.m_oraCharLevel1[n6] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            }
        }
        if (n == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
        return n;
    }

    int toOracleCharacterWithReplacement(char c, char c2) {
        int n = -1;
        if (c2 != '\u0000') {
            int n2 = c >>> 8 & 0xFF;
            int n3 = c & 0xFF;
            int n4 = c2 >>> 8 & 0xFF;
            int n5 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n2] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c >>> 8 & 0xFF;
            int n7 = c & 0xFF;
            if (this.m_oraCharLevel1[n6] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            }
        }
        if (n == -1) {
            if (c > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            if (cArray[n3] >= '\ud800' && cArray[n3] < '\udc00') {
                if (n3 + 1 >= n || cArray[n3 + 1] < '\udc00' || cArray[n3 + 1] > '\udfff') throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
                n4 = this.toOracleCharacterWithReplacement(cArray[n3], cArray[n3 + 1]);
                ++n3;
            } else {
                n4 = this.toOracleCharacter(cArray[n3], '\u0000');
            }
            if (n4 >> 24 != 0) {
                byArray[n2++] = (byte)(n4 >> 24);
                byArray[n2++] = (byte)(n4 >> 16);
                byArray[n2++] = (byte)(n4 >> 8);
                byArray[n2++] = (byte)n4;
            } else if (n4 >> 16 != 0) {
                byArray[n2++] = (byte)(n4 >> 16);
                byArray[n2++] = (byte)(n4 >> 8);
                byArray[n2++] = (byte)n4;
            } else if (n4 >> 8 != 0) {
                byArray[n2++] = (byte)(n4 >> 8);
                byArray[n2++] = (byte)n4;
            } else {
                byArray[n2++] = (byte)n4;
            }
            ++n3;
        }
        if (n2 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            block12: {
                int n4;
                block11: {
                    block9: {
                        block10: {
                            if (cArray[n3] < '\ud800' || cArray[n3] > '\udbff') break block9;
                            if (n3 + 1 >= n || cArray[n3 + 1] < '\udc00' || cArray[n3 + 1] > '\udfff') break block10;
                            n4 = this.toOracleCharacterWithReplacement(cArray[n3], cArray[n3 + 1]);
                            ++n3;
                            break block11;
                        }
                        byArray[n2++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n2++] = (byte)this.m_2ByteOraCharReplacement;
                        break block12;
                    }
                    n4 = this.toOracleCharacterWithReplacement(cArray[n3], '\u0000');
                }
                if (n4 >> 24 != 0) {
                    byArray[n2++] = (byte)(n4 >> 24);
                    byArray[n2++] = (byte)(n4 >> 16);
                    byArray[n2++] = (byte)(n4 >> 8);
                    byArray[n2++] = (byte)n4;
                } else if (n4 >> 16 != 0) {
                    byArray[n2++] = (byte)(n4 >> 16);
                    byArray[n2++] = (byte)(n4 >> 8);
                    byArray[n2++] = (byte)n4;
                } else if (n4 >> 8 != 0) {
                    byArray[n2++] = (byte)(n4 >> 8);
                    byArray[n2++] = (byte)n4;
                } else {
                    byArray[n2++] = (byte)n4;
                }
            }
            ++n3;
        }
        if (n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    protected boolean isOraCharacterReplacement(char c, char c2) {
        int n = this.toOracleCharacterWithReplacement(c, c2);
        return n == this.getOraChar1ByteRep() || n == this.getOraChar2ByteRep();
    }

    public void buildUnicodeToOracleMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        char[] cArray;
        int n5;
        int n6;
        Object object;
        int n7;
        this.m_oraCharLevel1 = new char[256];
        char[] cArray2 = null;
        int[] nArray = null;
        Vector vector = new Vector(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        char c = '\u0000';
        char c2 = '\u0000';
        int n8 = 0;
        while (n8 < 256) {
            this.m_oraCharLevel1[n8] = 65535;
            ++n8;
        }
        int n9 = 0;
        while (n9 < this.m_ucsCharLeadingCode.length) {
            int n10 = this.m_ucsCharLeadingCode[n9][0] << 16;
            n7 = 0;
            while (n7 < 65535) {
                try {
                    int n11 = this.toUnicode(n10 | n7);
                    object = new int[2];
                    object[0] = n11;
                    object[1] = n10 | n7;
                    vector.addElement(object);
                    this.storeMappingRange(n11, hashtable, hashtable2);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ++n7;
            }
            ++n9;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n6 = this.extraUnicodeToOracleMapping.length;
            n7 = 0;
            while (n7 < n6) {
                n5 = this.extraUnicodeToOracleMapping[n7][0];
                this.storeMappingRange(n5, hashtable, hashtable2);
                ++n7;
            }
        }
        Enumeration enumeration = hashtable.keys();
        int n12 = 0;
        int n13 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable.get(object);
            if (cArray == null) continue;
            n12 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable2.get(object);
            if (cArray == null) continue;
            n13 += 256;
        }
        if (n12 != 0) {
            cArray2 = new char[n12];
        }
        if (n13 != 0) {
            nArray = new int[n13];
        }
        int n14 = 0;
        while (n14 < n12) {
            cArray2[n14] = 65535;
            ++n14;
        }
        int n15 = 0;
        while (n15 < n13) {
            nArray[n15] = -1;
            ++n15;
        }
        int n16 = 0;
        while (n16 < vector.size()) {
            int[] nArray2 = (int[])vector.elementAt(n16);
            n4 = nArray2[0] >>> 24 & 0xFF;
            n3 = nArray2[0] >>> 16 & 0xFF;
            n2 = nArray2[0] >>> 8 & 0xFF;
            n = nArray2[0] & 0xFF;
            if (n4 >= 216 && n4 < 220) {
                if (this.m_oraCharLevel1[n4] == '\uffff') {
                    this.m_oraCharLevel1[n4] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (cArray2[this.m_oraCharLevel1[n4] + n3] == '\uffff') {
                    cArray2[this.m_oraCharLevel1[n4] + n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (cArray2[cArray2[this.m_oraCharLevel1[n4] + n3] + n2] == '\uffff') {
                    cArray2[cArray2[this.m_oraCharLevel1[n4] + n3] + n2] = c;
                    c = (char)(c + 256);
                }
                if (nArray[cArray2[cArray2[this.m_oraCharLevel1[n4] + n3] + n2] + n] == -1) {
                    nArray[cArray2[cArray2[this.m_oraCharLevel1[n4] + n3] + n2] + n] = nArray2[1];
                }
            } else {
                if (this.m_oraCharLevel1[n2] == '\uffff') {
                    this.m_oraCharLevel1[n2] = c;
                    c = (char)(c + 256);
                }
                if (nArray[this.m_oraCharLevel1[n2] + n] == -1) {
                    nArray[this.m_oraCharLevel1[n2] + n] = nArray2[1];
                }
            }
            ++n16;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n6 = this.extraUnicodeToOracleMapping.length;
            int n17 = 0;
            while (n17 < n6) {
                n5 = this.extraUnicodeToOracleMapping[n17][0];
                n4 = n5 >>> 24 & 0xFF;
                n3 = n5 >>> 16 & 0xFF;
                n2 = n5 >>> 8 & 0xFF;
                n = n5 & 0xFF;
                if (n4 >= 216 && n4 < 220) {
                    if (this.m_oraCharLevel1[n4] == '\uffff') {
                        this.m_oraCharLevel1[n4] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    if (cArray2[this.m_oraCharLevel1[n4] + n3] == '\uffff') {
                        cArray2[this.m_oraCharLevel1[n4] + n3] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    if (cArray2[cArray2[this.m_oraCharLevel1[n4] + n3] + n2] == '\uffff') {
                        cArray2[cArray2[this.m_oraCharLevel1[n4] + n3] + n2] = c;
                        c = (char)(c + 256);
                    }
                    nArray[cArray2[cArray2[this.m_oraCharLevel1[n4] + n3] + n2] + n] = this.extraUnicodeToOracleMapping[n17][1];
                } else {
                    if (this.m_oraCharLevel1[n2] == '\uffff') {
                        this.m_oraCharLevel1[n2] = c;
                        c = (char)(c + 256);
                    }
                    nArray[this.m_oraCharLevel1[n2] + n] = this.extraUnicodeToOracleMapping[n17][1];
                }
                ++n17;
            }
        }
        this.m_oraCharLevel2 = nArray;
        this.m_oraCharSurrogateLevel = cArray2;
    }

    public void extractCodepoints(Vector vector) {
        int n = 0;
        while (n < this.m_ucsCharLeadingCode.length) {
            char c = this.m_ucsCharLeadingCode[n][0];
            int n2 = c << 16;
            int n3 = n2 + 65535;
            int n4 = n2;
            while (n4 <= n3) {
                try {
                    int[] nArray = new int[]{n4, this.toUnicode(n4)};
                    vector.addElement(nArray);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ++n4;
            }
            ++n;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n = 0;
        while (n < this.extraUnicodeToOracleMapping.length) {
            vector.addElement(this.extraUnicodeToOracleMapping[n]);
            ++n;
        }
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }
}

