package kr.co.comsquare.db;

import java.sql.*;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;
import kr.co.comsquare.util.Utils;


/**
 * Ÿ̽κ ȸ  Ǿ ִ ClassԴϴ.<br>Ÿ̽ ̺     2 
 * Ǿ ֽϴ.  Class ̿ϸ ̳ JSP ٸ ̳ JSP  Request forward 
 * Ÿ̽κ ȸ    ֽϴ.<br>
 *  Ȱÿ Business Logic Presentation иϴ   ,   , Ȯ强, 
 *    ־ ȿԴϴ.
 * ̿Ͱ Servlet Business Logic ۼϰ    Ÿ  Class Ƽ Request Ͽ
 * JSP  ϸ JSP  Ÿ ̿Ͽ Presentation ϵ ý   ֽϴ.
 */

public class SaveResultSet
{
	protected Hashtable table;
	protected int iCursor;
	protected int iTotalRow;
	protected int iTotalCol;
	protected String colsep;
	protected String rowsep;

	
	/**
	 * SaveResultSet ü ϰ Ŀ ġ ù ° ٷ մϴ..
	 */
	public SaveResultSet()
	{
		table = new Hashtable();
		iCursor = 0;
		iTotalRow = 0;
		iTotalCol = 0;
	}

	
	/**
	 * Ŀ ġ   ű鼭 Ÿ ִ  Ȯմϴ.
	 * 
	 * @return   ࿡ Ÿ  true,  false return մϴ.
	 */	
	public boolean next()
	{
		boolean bReturn;

		if(iTotalRow <= iCursor)
			bReturn = false;
		else
			bReturn = true;

		iCursor++;

		return bReturn;
	}

	/**
	 *  ࿡ key(÷) short Ÿ Ÿ մϴ.
	 *
	 * @param   key		 Ÿ ã  key(÷) մϴ.
	 * @param   data	  key(÷) õ Ÿ
	 * @throws	NullPointerException key(÷) null  
	 */
	public void set(String key, short data) throws NullPointerException
	{
		if(key == null)
			throw new NullPointerException("Parameter 1 must have a value to be Not null");
		set(key, String.valueOf(data));
	}

	
	/**
	 *  ࿡ key(÷) int Ÿ Ÿ մϴ.
	 *
	 * @param   key		 Ÿ ã  key(÷) մϴ.
	 * @param   data	  key(÷) õ Ÿ
	 * @throws	NullPointerException key(÷) null  
	 */
	public void set(String key, int data) throws NullPointerException
	{
		if(key == null)
			throw new NullPointerException("Parameter 1 must have a value to be Not null");
		set(key, String.valueOf(data));
	}

	
	/**
	 *  ࿡ key(÷) long Ÿ Ÿ մϴ.
	 *
	 * @param   key		 Ÿ ã  key(÷) մϴ.
	 * @param   data	  key(÷) õ Ÿ
	 * @throws	NullPointerException key(÷) null  
	 */
	public void set(String key, long data) throws NullPointerException
	{
		if(key == null)
			throw new NullPointerException("Parameter 1 must have a value to be Not null");
		set(key, String.valueOf(data));
	}

	
	/**
	 *  ࿡ key(÷) double Ÿ Ÿ մϴ.
	 *
	 * @param   key		 Ÿ ã  key(÷) մϴ.
	 * @param   data	  key(÷) õ Ÿ
	 * @throws	NullPointerException key(÷) null  
	 */
	public void set(String key, double data) throws NullPointerException
	{
		if(key == null)
			throw new NullPointerException("Parameter 1 must have a value to be Not null");
		set(key, String.valueOf(data));
	}

	
	/**
	 *  ࿡ key(÷) float Ÿ Ÿ մϴ.
	 *
	 * @param   key		 Ÿ ã  key(÷) մϴ.
	 * @param   data	  key(÷) õ Ÿ
	 * @throws	NullPointerException key(÷) null  
	 */
	public void set(String key, float data) throws NullPointerException
	{
		if(key == null)
			throw new NullPointerException("Parameter 1 must have a value to be Not null");
		set(key, String.valueOf(data));
	}

	
	/**
	 *  ࿡ key(÷) String Ÿ Ÿ մϴ.
	 *
	 * @param   key		 Ÿ ã  key(÷) մϴ.
	 * @param   data	  key(÷) õ Ÿ
	 * @throws	NullPointerException key(÷) null  
	 */
	public void set(String key, String data) throws NullPointerException
	{
		if(key == null)
			throw new NullPointerException("Parameter 1 must have a value to be Not null");

		//edit sura
		if( data !=null){
			data = orgReplace(data, rowsep, colsep);
		}

		Vector v = (Vector)table.get(key);

		if(v == null)
		{
			v = new Vector();
			table.put(key, v);
			iTotalCol++;
		}

		while(v.size() < iCursor)
			v.add(null);

		if(v.size() == iCursor)
			v.add(data);
		else
			v.set(iCursor, data);

		if(iTotalRow == iCursor)
			iTotalRow++;
	}

	
	/**
	 *  ࿡ key(÷) Date Ÿ Ÿ մϴ.
	 *
	 * @param   key		 Ÿ ã  key(÷) մϴ.
	 * @param   data	  key(÷) õ Ÿ
	 * @throws	NullPointerException key(÷) null  
	 */
	public void set(String key, Date data) throws NullPointerException
	{
		if(key == null)
			throw new NullPointerException("Parameter 1 must have a value to be Not null");

		if(data == null)
			set(key, (String)null);
		else
			set(key, data.toString());
	}

	
	/**
	 *  ࿡ key(÷) Time Ÿ Ÿ մϴ.
	 *
	 * @param   key		 Ÿ ã  key(÷) մϴ.
	 * @param   data	  key(÷) õ Ÿ
	 * @throws	NullPointerException key(÷) null  
	 */
	public void set(String key, Time data) throws NullPointerException
	{
		if(key == null)
			throw new NullPointerException("Parameter 1 must have a value to be Not null");

		if(data == null)
			set(key, (String)null);
		else
			set(key, data.toString());
	}

	
	/**
	 *  ࿡ key(÷) Timestamp Ÿ Ÿ մϴ.
	 *
	 * @param   key		 Ÿ ã  key(÷) մϴ.
	 * @param   data	  key(÷) õ Ÿ
	 * @throws	NullPointerException key(÷) null  
	 */
	public void set(String key, Timestamp data) throws NullPointerException
	{
		if(key == null)
			throw new NullPointerException("Parameter 1 must have a value to be Not null");

		if(data == null)
			set(key, (String)null);
		else
			set(key, data.toString());
	}

	
	/**
	 *  ࿡ key(÷) شϴ String(Ÿ̽    ÷ 
	 *  Ÿ) ϴ.
	 *
	 * @param   key		Ÿ ã  key(÷)
	 * @return   ࿡ key(÷) شϴ String
	 */
	public String get(String key) throws NullPointerException
	{
		String strReturn = null;
		if(key == null)
			throw new NullPointerException("Parameter 1 must have a value to be Not null");
		try
		{
			Vector v = (Vector)table.get(key);
			strReturn = (String)v.get(iCursor-1);
		}
		catch(Exception e) {}
		finally
		{
			if(strReturn == null)
				return "";
			else
				return strReturn;
		}
	}

	/**
	 * Ŀ ù ° ٷ ̵մϴ. Ÿ̽ ȸ   Ͽ
	 *  Լ ȣϿ Ŀ ù ° ٷ ̵Ѿ ٽ ͸    ֽϴ.
	 */
	public void first()
	{
		iCursor = 0;
	}
	
	/**
	 * Ǿ ִ Ÿ (Row)  Ȯմϴ.
	 * 
	 * @return   
	 */
	public int getTotalRow()
	{
		return iTotalRow;
	}
	
	/**
	 * Ǿ ִ Ÿ (Col)  Ȯմϴ.
	 * 
	 * @return   
	 */
	public int getTotalCol()
	{
		return table.size();
	}
	
	/**
	 * Ǿ ִ Ÿ ÷ ȯմϴ.
	 * 
	 * @return  ÷ 
	 */
	public Hashtable getColName()
	{
		return table;
	}
	
	/**
	 * Ǿ ִ Ÿ ÷ ȯմϴ.
	 * 
	 * @return  ÷ 
	 */
	public String[] getColNameArray()
	{
		String[] strarr = new String[table.size()];
		Enumeration ei = table.keys();

		for(int i=0;  ei.hasMoreElements(); i++ ){
			strarr[i] = (String)ei.nextElement();
		}
		return strarr;
	}
	
	/**
	 *   մϴ.
	 * 
	 * @param   rowsep 	row 
	 * @param   colsep 	collum 
	 */
	public void setSep( String rowsep, String colsep){
		this.colsep = colsep;
		this.rowsep = rowsep;
	}

	/**
	 * Ƽ update data  ڰ Ե  ߴ Ư ڸ  ڿ ȯմϴ.
	 * ex) /^ -> \^
	 * 
	 * @param   str			  ڿ
	 * @param   rowsep 	row 
	 * @param   colsep 	collum 
	 * @return   str 	 ڿ
	 */
	public static String orgReplace(String str, String rowsep, String colsep){
		String temp = str;

		//temp = Utils.replace(str, "SLashslaSH", "/");
		temp = Utils.replace(temp,  "\\"+colsep,  colsep );
		temp = Utils.replace(temp, "\\"+rowsep, rowsep );
		str = temp;

		return str;
	}

/*	// ׽Ʈ
	public static void main(String[] args) 
	{
		SaveResultSet rs = new SaveResultSet();
		
		// save
		for(int i = 0; i < 10; i++)
		{
			rs.set("test1", i);
			rs.set("test1", i);
			rs.set("test2", i);
			rs.set("test3", i);
			rs.next();
		}
		rs.set("a",1);

		rs.first();

		System.out.print(rs.getTotalRow() + "");
		System.out.println(rs.getTotalCol() + "");

		while(rs.next())
		{
			System.out.print(rs.get("test1") + "");
			System.out.print(rs.get("test2") + "");
			System.out.println(rs.get("test3") + "");
		}
	}*/
}
