package kr.co.comsquare.pushServer;
import java.io.*;
import java.net.*;

public class MClient extends Thread{
	
	private String msg; //Ŭ̾Ʈ  ޼.
	private String clientIP; // Ŭ̾Ʈ IP
	private int port; //Ŭ̾Ʈ port
	private int status; // Ŭ̾Ʈ  (  )
	private Socket sock; // Ŭ̾Ʈ  
	private OutputStream os; // Ŭ̾Ʈ  κ   Ʈ
	private BufferedOutputStream bos; //Ŭ̾Ʈ  κ   Ʈ
	//private PrintWriter prw;
	
	private InputStream is; // Ŭ̾Ʈ  κ  Է Ʈ
	private BufferedInputStream bis; //Ŭ̾Ʈ  κ  Է Ʈ	
	
	//private final int SEND=0;
	//private final int RECV=1;
	//private boolean success;
	private MServer server; // server (addFailedClient) ϱ  . 
	
	
	/**
	 * MClient . 
	 * 
	 *    
	 * @param server ڸ ȣ MServer ü
	 * 
	 */	
	public MClient(MServer server){
		this.server=server;
	}
	
	/**
	 * MClient .
	 * 
	 * @param ip Ŭ̾Ʈ IP
	 * @param port Ŭ̾Ʈ SAP(port)
	 * @param server ڸ ȣ MServer ü
	 */	
	public MClient(String ip,int port,MServer server){
		try{
			this.clientIP=ip;
			this.port=port;
			this.server=server;
//			System.out.println("connect?");
	
		}catch(Exception e){
			Log.setLog("Exception in Constructor of MClient, "+ this.clientIP+":"+this.port+" "+ e.toString());
		}		
	}

	/**
	 * ׽Ʈ  MClient . (MServerü  ʿ䰡 .)
	 * 
	 * @param ip Ŭ̾Ʈ IP
	 * @param port Ŭ̾Ʈ SAP(port)
	 */
	//׽Ʈ .
	public MClient(String ip,int port){
		try{
			this.clientIP=ip;
			this.port=port;
			this.server=server;

			//prw=new PrintWriter(os);
		}catch(Exception e){
			Log.setLog("Exception in Constructor of MClient, "+e.toString());			
		}		
	}
	
	/**
	 * ʱȭѴ.
	 * 
	 * 
	 * 
	 */
	public void initialize(){
		try{
			if(!sock.isConnected())
				sock=new Socket(this.clientIP,this.port);
			os=sock.getOutputStream();
			is=sock.getInputStream();
			bos=new BufferedOutputStream(os);
			bis=new BufferedInputStream(is);			
		}catch(Exception e){
			Log.setLog("Exception is occured in initialize() method of Mclient class, "+ e.toString());
		}
	}
	
	/**
	 * ʱȭ Ѵ.
	 * 
	 * @param ip Ŭ̾Ʈ IP
	 * @param port Ŭ̾Ʈ SAP(port)
	 */
	public void initialize(String ip,int port){
		try{
			this.clientIP=ip;
			this.port=port;
			if(!sock.isConnected())
				sock=new Socket(this.clientIP,this.port);
			os=sock.getOutputStream();
			is=sock.getInputStream();
			bos=new BufferedOutputStream(os);
			bis=new BufferedInputStream(is);
		}catch(Exception e){
			Log.setLog("Exception is occured in initialize(String ip,int port) method of Mclient class, "+ e.toString());
		}
	}
	
	/**
	 * Ŭ̾Ʈ IP ´.
	 * @return
	 */
	public String getIP(){
		return this.clientIP;
	}
	
	/**
	 * Ŭ̾Ʈ SAP(port) ´.
	 * @return
	 */
	public int getPort(){
		return this.port;
	}
	
	/**
	 * Ŭ̾Ʈ ۵ ޼ ´.
	 * @return
	 */
	public String getMsg(){
		return this.msg;
	}
	
	/**
	 * Ŭ̾Ʈ ۵ ޼ Ѵ.
	 * @param msg
	 */
	public void setMsg(String msg){
		this.msg=msg;
	}
	
	/**
	 * Ŭ̾Ʈ  Ѵ.
	 */
	public void disconnect(){
		try{
			if(sock.isConnected())
				sock.close();
		}catch(Exception e){
			Log.setLog("Exception is occured in disconnect() method of Mclient, "+ e.toString());
		}
	}
	
	/**
	 * Ŭ̾Ʈ ޼ Ѵ.
	 * @param msg Ŭ̾Ʈ ۵ ޼.
	 */
	public void sendMsg(String msg){	
		this.msg=msg;
		
			this.start();
		
		
		//		return this.success;
	}
	
		
	public void setIP(String ip){
		this.clientIP=ip;
	}	
	
	public void setPort(int port){
		this.port=port;
	}	
	
	/*
	 *    thread routine
	 */
	public void run(){
		try{	
				sock=new Socket(this.clientIP,this.port);
			if(this.sock!=null&&this.sock.isConnected()){			
				
	//			System.out.println("connect?");
				os=sock.getOutputStream();
				is=sock.getInputStream();
				bos=new BufferedOutputStream(os);
				bis=new BufferedInputStream(is);
				byte[] msgB=this.msg.getBytes();
				System.out.println(msgB.length);
				bos.write(msgB, 0, msgB.length );
				bos.flush();
				Thread.sleep(500);
				//bos.notify();
			//	bos.close();
				disconnect();
			// TODO if(!success)
				Log.setLog("message("+this.msg +") is sent to "+this.clientIP+":"+this.port );	
			}else{
				System.out.println("fail");
				server.addFailedClient(this);			
			}
		}catch(Exception e){
			System.out.println("fail");
			server.addFailedClient(this);
			Log.setLog("exception is occured while sending message to " + this.clientIP+":" + this.port + " "+ e.toString());			
		}
	}
	
	public static void main(String[] args) throws InterruptedException {
		// TODO Auto-generated method stub
		MServer ms= new MServer();
		//MClient mc=new MClient("127.0.0.1",23015,ms);
		MClient mc1=new MClient("127.0.0.1",23016,ms);
		//mc.sendMsg("12");
		mc1.sendMsg("2213213213213213");
		//Thread.sleep(1000);
	}
}