package kr.co.comsquare.pushServer;

import java.util.Vector;
import kr.co.comsquare.util.Tokenizer;

public class MServer { 
		
	private String curClientIP;	
	private MClient[] clients;
	private FileMng clientInfoFile;	
	private FileMng failedClient;
	private Vector clientInfo;
	private Vector fails;
	private int clientPort;
	private boolean redo;
	
	/**
	 * Mserver .
	 * 
	 * @param args
	 */	
	public MServer(){
		clientInfo=new Vector();
		fails=new Vector();
		clientInfoFile=new FileMng("C:\\\\pushServerFiles\\ClientInfo");
		failedClient=new FileMng("C:\\\\pushServerFiles\\failedClient");
		failedClient.clear();
		clientPort=23015; //Ŭ̾Ʈ  Ʈ				
	}
	
	/**
	 * Mserver .
	 *  о   ִ. 
	 * 
	 * @param clientInfoFilePath  Ŭ̾Ʈ  ϴ 
	 * @param failedClientFilePath ۿ  Ŭ̾Ʈ  ϴ 
	 */
	public MServer(String clientInfoFilePath, String failedClientFilePath){
		clientInfo=new Vector();
		fails=new Vector();
		clientInfoFile=new FileMng(clientInfoFilePath);
		failedClient=new FileMng(failedClientFilePath);
		clientPort=23015; //Ŭ̾Ʈ  Ʈ
		//Log.setLog("Message server is constructed.");
	}
	
	/**
	 *   ʱȭ Ѵ.
	 *   ۾ 켱 Ǿ Ѵ.
	 * 
	 */
	public void initServer(){
		try{
			MClient client;
			String ip=null;
			int port=0;
			Tokenizer token;
			String tmp=null;
			clientInfo.clear();
			fails.clear();
			for(int i=0;i<clientInfoFile.getLineCnt();i++){
				tmp=clientInfoFile.getLine(i);
				token=new Tokenizer(tmp,":");
				if(token.next())
					ip=token.getString();
				if(token.next()) //   Ʈ  ִٸ װ Ѵ. 
					port=Integer.parseInt(token.getString());
				else			 // ׷ ʴٸ ⺻ Ʈ Ѵ.
					port=this.clientPort;
				clientInfo.add(new MClient(ip,port,this));
			}
			for(int i=0;i<failedClient.getLineCnt();i++){
				tmp=failedClient.getLine(i);
				fails.add(new MClient(tmp,this.clientPort,this));
			}
		}catch(Exception e){
			Log.setLog("Exception is occured in initServer method of MServer class:"+e.toString());
		}
		//Log.setLog("initialize server");
	}
	
	/**
	 * 	Ͽ Ŭ̾Ʈ Ʈ Է¹޾ ޼ Ѵ.
	 * 
	 * @param msg  ޼
	 */
	public void sendMsg(String msg){
		int i=0;
		MClient client;
		for( i=0;i<clientInfo.size();i++){
			client=(MClient)clientInfo.get(i);
			client.sendMsg(msg);
		}
		Log.setLog("sending all the messages...");
	}
	
	/**
	 * ڷκ  Ŭ̾Ʈ Ʈ Է¹޾ ٷ Ѵ. 
	 * 
	 * @param ips
	 * @param port
	 * @param msg
	 */
	public void sendMsgDirect(String ips,int port, String msg){
		try{
			MClient mc=new MClient(this);
			String tmp=null;
			Tokenizer portToken=new Tokenizer(ips,":");
			Tokenizer token=new Tokenizer(ips,",");
			while(token.next()){
				tmp=token.getString();
				if(tmp.indexOf(":")==-1){
					mc.setIP(tmp);
					mc.setPort(port);
				}else{
					portToken.next();
					mc.setIP(portToken.getString());
					portToken.next();
					mc.setPort(Integer.parseInt(portToken.getString()));
				}
				mc.initialize();
				mc.sendMsg(msg);
				clientInfoFile.addLine(tmp);				
				clientInfoFile.flush();
				Log.setLog("sending all the messages...");
			}
		}catch(Exception e){
			Log.setLog("Exception is occured in addClient(String clientIP,int port) of MServer class:"+e.toString());
		}
	}
	
	/**
	 * ο Ŭ̾Ʈ ߰Ѵ.
	 * 
	 * @param clientIP ο Ŭ̾Ʈ IP
	 */
	public void addClient(String clientIP){
		//clientInfo.add(new MClient(clientIP,clientPort,this));
		String ip=null;
		try{
			Tokenizer token=new Tokenizer(clientIP,",");
			while(token.next()){
				if(isClient(ip,clientPort))
					continue;
				clientInfoFile.addLine(ip);
				clientInfoFile.flush();
				Log.setLog("new client("+ip+") is added.");
			}
		}catch(Exception e){
			Log.setLog("Exception is occured in addClient() method of MServer class: "+ e.toString());
		}
	}
	
	/**
	 * ο Ŭ̾Ʈ ߰Ѵ.
	 * 
	 * @param clientIP ο Ŭ̾Ʈ IP 
	 * @param port ο Ŭ̾Ʈ SAP(port)
	 */
	public void addClient(String clientIP,int port){
		try{		
			
			String tmp=null;
			String tmp2=null;
			String tmp3=null;
			Tokenizer portToken;
			Tokenizer token=new Tokenizer(clientIP,",");
			while(token.next()){
				tmp=token.getString();
				if(tmp.indexOf(":")==-1){
					
					tmp=tmp+":"+String.valueOf(port);					
				}
				portToken=new Tokenizer(tmp,":");
				portToken.next();
				tmp2=portToken.getString();
				portToken.next();
				tmp3=portToken.getString();
				if(isClient(tmp2,Integer.parseInt(tmp3)))
					continue;				
				clientInfoFile.addLine(tmp);				
				clientInfoFile.flush();
				Log.setLog("new client("+tmp+") is added.");
			}
			
		}catch(Exception e){
			Log.setLog("Exception is occured in addClient(String clientIP,int port) of MServer class:"+e.toString());
		}
	}
	
	/**
	 * ۿ  Ŭ̾Ʈ ߰Ѵ.
	 * 
	 * 
	 * @param client ۿ  Ŭ̾Ʈ.
	 */	
	public synchronized void addFailedClient(MClient client){
		this.fails.add(client);
		for(int i=0;i<failedClient.getLineCnt();i++){
			if(failedClient.getLine(i).equals(client)){
				return;
			}
		}
		failedClient.addLine(client.getIP());
		failedClient.flush();
	}
	
	/**
	 *  Ŭ̾Ʈ  Ѵ. 
	 * 
	 */
	public void removeClients(){
		clientInfoFile.clear();
		Log.setLog("remove all of the clients");
	}
	
	/**
	 * 
	 * Ŭ̾Ʈ   ´. 
	 */
	public void disconnect(){
		MClient client;
		while(true){
			client=(MClient)clientInfo.get(0);
			if(client==null)
				break;
			client.disconnect();
		}
		Log.setLog("disconnect from all of the clients");
	}
	
	/**
	 * 	Ͽ ۿ  Ŭ̾Ʈ Ʈ Է¹޾ ޼ Ѵ.
	 * 
	 * @param msg  ޼
	 */
	public void sendFailedMsg(){
		MClient client;		
		redo=true;
		Vector tmp=(Vector)fails.clone();
		fails.clear();
		failedClient.clear();
		for(int i=0;i<tmp.size();i++){
			client=(MClient)tmp.get(i);
			client.sendMsg(client.getMsg());
		}
		Log.setLog("sending all failed messages.....");
	}
	
	/**
	 * ⺻ Ʈ Ѵ. 
	 * @param port ⺻ Ʈ 
	 */
	public void setPort(int port){
		this.clientPort=port;
		Log.setLog("set client SAP(port):"+port );
	}
	/**
	 *  ϵǾִ Ŭ̾Ʈ üũѴ.
	 * 
	 * @param _ip üũ Ŭ̾Ʈ 
	 * @param _port üũ Ŭ̾Ʈ Ʈ
	 * @return ̹ ϵǾ true ׷  false
	 */
	public boolean isClient(String _ip,int _port)
	{				
		String tmp=null;
		fails.clear();
		for(int i=0;i<clientInfoFile.getLineCnt();i++){
			if(clientInfoFile.getLine(i).equals(_ip+":"+_port))			
				return true;
		}
		return false;	
	}
	/**
	 * Ŭ̾Ʈ Ʈ  Ư ip port  Ŭ̾Ʈ Ѵ.
	 * @param ip  Ŭ̾Ʈ ip
	 * @param port  Ŭ̾Ʈ port
	 */	
	
	public void removeClient(String ip,int port){
		this.initServer();
		MClient tmp;
		for(int i=0;i<clientInfo.size();i++){
			tmp=(MClient)clientInfo.get(i);
			if(tmp.getIP().equals(ip)&&tmp.getPort()==port){
				clientInfo.remove(i);
				break;
			}
		}
		clientInfoFile.clear();
		for(int i=0;i<clientInfo.size();i++){
			tmp=(MClient)clientInfo.get(i);
			this.addClient(tmp.getIP(),tmp.getPort());
		}
	}
	
	/**
	 * ü Ŭ̾Ʈ  ƮѴ.
	 *
	 */	
	
	public void reportClientList(){ 
		this.initServer();
		MClient tmp;
		String ip;
		int port;
		for(int i=0;i<clientInfo.size();i++){
			tmp=(MClient)clientInfo.get(i);
			//List ϱ.
			ip=tmp.getIP();
			port=tmp.getPort();
			System.out.println(ip+":"+port);
		}
	}
	
	
	public static void main(String[] args) {
		MServer ms=new MServer();
		ms.addClient("127.0.0.1",12346);
//		ms.initServer();
//		ms.sendMsg("Hi, this is jeongHoon7");
		// TODO Auto-generated method stub
	}
	
}